/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.config.DefaultArtifactEncoding;
import org.mule.runtime.core.internal.config.FeatureFlaggingServiceBuilder;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.NullLifecycleInterceptor;
import org.mule.runtime.core.internal.registry.AbstractRegistry;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleContextProcessor;
import org.mule.runtime.core.internal.registry.map.RegistryMap;
import org.mule.runtime.core.internal.util.InjectionUtils;
import org.mule.runtime.core.privileged.registry.InjectProcessor;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.reflections.ReflectionUtils;
import org.reflections.util.ReflectionUtilsPredicates;
import org.slf4j.Logger;

public class SimpleRegistry
extends AbstractRegistry
implements Injector {
    private static final String REGISTRY_ID = "org.mule.runtime.core.Registry.Simple";
    private final boolean disableApplyObjectProcessor;
    private final RegistryMap registryMap;

    public SimpleRegistry(MuleContext muleContext) {
        this(muleContext, new NullLifecycleInterceptor());
    }

    public SimpleRegistry(MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        this(muleContext, lifecycleInterceptor, muleContext != null ? Optional.of(SimpleRegistry.createFeatureFlaggingService(muleContext)) : Optional.empty());
    }

    public SimpleRegistry(MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor, Optional<FeatureFlaggingService> featureFlaggingService) {
        this(muleContext, lifecycleInterceptor, featureFlaggingService, RegistryMap::new);
    }

    SimpleRegistry(MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor, Optional<FeatureFlaggingService> featureFlaggingService, Function<Logger, RegistryMap> registryMapProvider) {
        super(REGISTRY_ID, muleContext, lifecycleInterceptor);
        this.registryMap = registryMapProvider.apply(this.logger);
        if (featureFlaggingService.isPresent()) {
            this.disableApplyObjectProcessor = featureFlaggingService.get().isEnabled((Feature)MuleRuntimeFeature.DISABLE_APPLY_OBJECT_PROCESSOR);
            this.putDefaultEntriesIntoRegistry(featureFlaggingService.get());
        } else {
            this.disableApplyObjectProcessor = true;
            this.putDefaultEntriesIntoRegistry(null);
        }
    }

    private void putDefaultEntriesIntoRegistry(FeatureFlaggingService featureFlaggingService) {
        HashMap<String, Object> defaultEntries = new HashMap<String, Object>();
        if (this.getMuleContext() != null) {
            defaultEntries.put("_muleContext", this.getMuleContext());
            defaultEntries.put("_muleRegistry", new DefaultRegistry(this.getMuleContext()));
            defaultEntries.put("_muleContextProcessor", new MuleContextProcessor(this.getMuleContext()));
            defaultEntries.put("_muleNotificationHandler", this.getMuleContext().getNotificationManager());
            defaultEntries.put("_muleArtifactEncoding", new DefaultArtifactEncoding(this.getMuleContext().getConfiguration().getDefaultEncoding()));
            defaultEntries.put("core.featureFlaggingService", featureFlaggingService);
        }
        defaultEntries.put("_muleLifecycleManager", this.getLifecycleManager());
        this.registryMap.putAll(defaultEntries);
    }

    public static FeatureFlaggingService createFeatureFlaggingService(MuleContext muleContext) {
        FeatureFlaggingRegistry ffRegistry = FeatureFlaggingRegistry.getInstance();
        return new FeatureFlaggingServiceBuilder().withContext(muleContext).withContext(new FeatureContext(muleContext.getConfiguration().getMinMuleVersion().orElse(null), SimpleRegistry.resolveArtifactName(muleContext))).withMuleContextFlags(ffRegistry.getFeatureConfigurations()).withFeatureContextFlags(ffRegistry.getFeatureFlagConfigurations()).build();
    }

    private static String resolveArtifactName(MuleContext muleContext) {
        if (muleContext.getConfiguration() != null) {
            return muleContext.getConfiguration().getId();
        }
        return "";
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.injectFieldDependencies();
        this.applyProcessors(this.lookupObjects(Transformer.class), null);
        this.applyProcessors(this.lookupObjects(Object.class), null);
    }

    @Override
    protected void doDispose() {
        this.disposeLostObjects();
        this.registryMap.clear();
    }

    private void disposeLostObjects() {
        for (Object obj : this.registryMap.getLostObjects()) {
            try {
                ((Disposable)obj).dispose();
            }
            catch (Exception e) {
                this.logger.warn("Can not dispose object. {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                this.logger.debug("Can not dispose object. {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void checkDisposed() throws RegistrationException {
        if (this.getLifecycleManager().isPhaseComplete("dispose")) {
            throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)"Cannot register objects on the registry as the context is disposed"));
        }
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.doGet(key);
    }

    private <T> T doGet(String key) {
        return this.registryMap.get(key);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> returntype) {
        return this.registryMap.select(returntype::isInstance);
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.lookupObjects(type);
    }

    @Override
    public boolean isSingleton(String key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            this.registryMap.lockForReading();
            for (Map.Entry<String, Object> entry : this.registryMap.entrySet()) {
                if (entry.getValue() == null) {
                    throw new NullPointerException("SimpleRegistry - null value for entry with key '" + entry.getKey() + "' of type '" + String.valueOf(type) + "'");
                }
                Class<?> clazz = entry.getValue().getClass();
                if (!type.isAssignableFrom(clazz)) continue;
                results.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.registryMap.unlockForReading();
        }
        return results;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    @Override
    public void registerObject(String key, Object object, Object metadata) throws RegistrationException {
        this.checkDisposed();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)"Attempt to register object with no key"));
        }
        this.logger.debug("registering key/object {}/{}", (Object)key, object);
        this.logger.debug("applying processors");
        this.doRegisterObject(key, this.applyProcessors(object, metadata));
    }

    @Override
    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            this.registerObject(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Object doUnregisterObject(String key) throws RegistrationException {
        return this.registryMap.remove(key);
    }

    private void doRegisterObject(String key, Object object) throws RegistrationException {
        Object previous = this.doGet(key);
        if (previous != null) {
            this.logger.debug("An entry already exists for key {}. It will be replaced", (Object)key);
            this.unregisterObject(key);
        }
        this.doPut(key, object);
        try {
            this.getLifecycleManager().applyCompletedPhases(object);
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    private void doPut(String key, Object object) {
        this.registryMap.putAndLogWarningIfDuplicate(key, object);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, startPhase, toPhase);
    }

    @Override
    public <T> T inject(T object) {
        object = InjectionUtils.getInjectionTarget(object);
        return (T)this.applyProcessors(object, null);
    }

    private Object applyProcessors(Object object, Object metadata) {
        return this.injectInto(this.doApplyProcessors(object, metadata));
    }

    private Object doApplyProcessors(Object object, Object metadata) {
        if (this.disableApplyObjectProcessor) {
            return object;
        }
        Object theObject = object;
        if (!this.hasFlag(metadata, 2)) {
            Collection<InjectProcessor> injectProcessors = this.lookupObjects(InjectProcessor.class);
            for (InjectProcessor processor : injectProcessors) {
                theObject = processor.process(theObject);
            }
        }
        return theObject;
    }

    private boolean hasFlag(Object metaData, int flag) {
        return metaData != null && metaData instanceof Integer && ((Integer)metaData & flag) != 0;
    }

    private void injectFieldDependencies() throws InitialisationException {
        this.lookupObjects(Object.class).forEach(this::injectInto);
    }

    private <T> T injectInto(T object) {
        this.doInjectInto(object, Inject.class, Named.class, Named::value);
        this.doInjectInto(object, javax.inject.Inject.class, javax.inject.Named.class, javax.inject.Named::value);
        return object;
    }

    private <T, N extends Annotation> void doInjectInto(T object, Class<? extends Annotation> injectAnnClass, Class<N> namedAnnClass, Function<N, String> namedValue) {
        for (Field field : ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(injectAnnClass)})) {
            this.injectToField(object, namedAnnClass, namedValue, field);
        }
        for (Method method : ReflectionUtils.getAllMethods(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(injectAnnClass)})) {
            this.injectToMethod(object, namedAnnClass, namedValue, method);
        }
    }

    private <N extends Annotation, T> void injectToField(T object, Class<N> namedAnnClass, Function<N, String> namedValue, Field field) {
        try {
            N namedAnnotation = field.getAnnotation(namedAnnClass);
            Object dependency = this.resolveTypedDependency(field.getType(), namedAnnotation != null ? namedValue.apply(namedAnnotation) : null, () -> ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
            field.setAccessible(true);
            if (dependency != null) {
                field.set(object, dependency);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not inject dependency on field %s of type %s", field.getName(), object.getClass().getName()), e);
        }
    }

    private <N extends Annotation, T> void injectToMethod(T object, Class<N> namedAnnClass, Function<N, String> namedValue, Method method) {
        if (method.getParameters().length == 1) {
            try {
                N namedAnnotation = method.getAnnotation(namedAnnClass);
                Object dependency = this.resolveTypedDependency(method.getParameterTypes()[0], namedAnnotation != null ? namedValue.apply(namedAnnotation) : null, () -> ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0]);
                if (dependency != null) {
                    method.invoke(object, dependency);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on method %s of type %s", method.getName(), object.getClass().getName()), e);
            }
        }
    }

    private Object resolveTypedDependency(Class<?> dependencyType, String namedAnnotationValue, Supplier<Type> typeSupplier) throws RegistrationException {
        boolean nullToOptional = false;
        boolean collection = false;
        if (dependencyType.equals(Optional.class)) {
            nullToOptional = true;
        } else if (Collection.class.isAssignableFrom(dependencyType)) {
            collection = true;
        }
        if (nullToOptional || collection) {
            Type type = typeSupplier.get();
            dependencyType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        }
        return this.resolveDependency(dependencyType, nullToOptional, collection, namedAnnotationValue);
    }

    private Object resolveDependency(Class<?> dependencyType, boolean nullToOptional, boolean collection, String namedAnnotationValue) throws RegistrationException {
        if (collection) {
            return this.resolveObjectsToInject(dependencyType);
        }
        return this.resolveObjectToInject(dependencyType, namedAnnotationValue, nullToOptional);
    }

    private Object resolveObjectToInject(Class<?> dependencyType, String name, boolean nullToOptional) throws RegistrationException {
        Object dependency = name != null ? this.lookupObject(name) : this.lookupObject(dependencyType);
        if (dependency == null && MuleContext.class.isAssignableFrom(dependencyType)) {
            dependency = this.getMuleContext();
        }
        return nullToOptional ? Optional.ofNullable(dependency) : dependency;
    }

    private <T> Collection<T> resolveObjectsToInject(Class<T> dependencyType) throws RegistrationException {
        Collection<T> dependencies = this.lookupObjects(dependencyType);
        return dependencies;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

