/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.FunctionModelParser;
import org.mule.runtime.extension.api.loader.parser.SemanticTermsParser;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

final class FunctionModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private final Map<FunctionModelParser, FunctionDeclarer> functionDeclarers = new HashMap<FunctionModelParser, FunctionDeclarer>();

    FunctionModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareFunctions(ExtensionDeclarer extensionDeclarer, List<FunctionModelParser> parsers, ExtensionLoadingContext context) {
        for (FunctionModelParser parser : parsers) {
            if (parser.isIgnored()) continue;
            if (this.functionDeclarers.containsKey(parser)) {
                extensionDeclarer.withFunction(this.functionDeclarers.get(parser));
                continue;
            }
            FunctionDeclarer function = (FunctionDeclarer)extensionDeclarer.withFunction(parser.getName()).describedAs(parser.getDescription());
            parser.getDeprecationModel().ifPresent(arg_0 -> ((FunctionDeclarer)function).withDeprecation(arg_0));
            parser.getFunctionExecutorFactory().map(FunctionExecutorModelProperty::new).ifPresent(arg_0 -> ((FunctionDeclarer)function).withModelProperty(arg_0));
            parser.getOutputType().applyOn(function.withOutput());
            this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)function, parser.getParameterGroupModelParsers(), context);
            parser.getAdditionalModelProperties().forEach(arg_0 -> ((FunctionDeclarer)function).withModelProperty(arg_0));
            if (context.isResolveMinMuleVersion()) {
                parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> MinMuleVersionUtils.declarerWithMmv(function, resolvedMMV));
            }
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)function.getDeclaration(), (SemanticTermsParser)parser);
            this.functionDeclarers.put(parser, function);
        }
    }
}

