/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.value;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.values.ValueBuilder;

public class ValueTypeAdapter
extends TypeAdapter<Value> {
    private static final String ID = "id";
    private static final String DISPLAY_NAME = "displayName";
    private static final String PART_NAME = "partName";
    private static final String CHILDS = "childs";

    public void write(JsonWriter jsonWriter, Value value) throws IOException {
        if (value != null) {
            jsonWriter.beginObject();
            jsonWriter.name(ID).value(value.getId());
            jsonWriter.name(DISPLAY_NAME).value(value.getDisplayName());
            jsonWriter.name(PART_NAME).value(value.getPartName());
            jsonWriter.name(CHILDS);
            jsonWriter.beginArray();
            for (Value child : value.getChilds()) {
                this.write(jsonWriter, child);
            }
            jsonWriter.endArray();
            value.getChilds();
            jsonWriter.endObject();
        }
    }

    public Value read(JsonReader jsonReader) throws IOException {
        return this.doRead(jsonReader).build();
    }

    private ValueBuilder doRead(JsonReader jsonReader) throws IOException {
        if (jsonReader != null) {
            String id = null;
            String displayName = null;
            String partName = null;
            LinkedHashSet<ValueBuilder> childs = new LinkedHashSet<ValueBuilder>();
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                switch (jsonReader.nextName()) {
                    case "id": {
                        id = jsonReader.nextString();
                        break;
                    }
                    case "displayName": {
                        displayName = jsonReader.nextString();
                        break;
                    }
                    case "partName": {
                        partName = jsonReader.nextString();
                        break;
                    }
                    case "childs": {
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            childs.add(this.doRead(jsonReader));
                        }
                        jsonReader.endArray();
                    }
                }
            }
            jsonReader.endObject();
            ValueBuilder valueBuilder = ValueBuilder.newValue(id, partName).withDisplayName(displayName);
            childs.forEach(childValueBuilder -> valueBuilder.withChild(childValueBuilder));
            return valueBuilder;
        }
        return null;
    }
}

