/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import org.mule.weave.v2.model.values.coercion.NumberUtils;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.model.values.math.Number$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;

public final class NumberUtils$ {
    public static NumberUtils$ MODULE$;
    private final int OK;
    private final int OVERFLOW;
    private final int INVALID_DATA;

    static {
        new NumberUtils$();
    }

    public int OK() {
        return this.OK;
    }

    public int OVERFLOW() {
        return this.OVERFLOW;
    }

    public int INVALID_DATA() {
        return this.INVALID_DATA;
    }

    public NumberUtils.ParsingResult fromString(String strNumber) {
        if (strNumber.isEmpty()) {
            return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
        }
        if (!strNumber.contains(".")) {
            if (strNumber.length() > 20) {
                return this.parseBigNumber(strNumber);
            }
            NumberUtils.ParsingResult result = this.parseLong(strNumber);
            if (result.resultType() == this.OK()) {
                return result;
            }
            return this.parseBigNumber(strNumber);
        }
        return this.parseBigDecimal(strNumber);
    }

    private NumberUtils.ParsingResult parseBigNumber(String strNumber) {
        NumberUtils.ParsingResult result = this.parseBigDecimal(strNumber);
        if (result.resultType() == this.OK()) {
            return result;
        }
        return this.parseBigDecimal(strNumber);
    }

    public NumberUtils.ParsingResult parseLong(String strNumber) {
        long num = 0L;
        int sign = -1;
        int len = strNumber.length();
        char ch = strNumber.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            num = -d;
        }
        long max = sign == -1 ? -Long.MAX_VALUE : Long.MIN_VALUE;
        long multmax = max / 10L;
        int i = 1;
        while (i < len) {
            int d = strNumber.charAt(i) - 48;
            ++i;
            if (d < 0 || d > 9) {
                return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
            }
            if (num < multmax) {
                return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.OVERFLOW());
            }
            if ((num *= 10L) < max + (long)d) {
                return new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.OVERFLOW());
            }
            num -= (long)d;
        }
        return new NumberUtils.ParsingResult((Option<Number>)new Some((Object)Number$.MODULE$.apply((long)sign * num)), this.OK());
    }

    private NumberUtils.ParsingResult parseBigInteger(String strNumber) {
        return new NumberUtils.ParsingResult((Option<Number>)new Some((Object)Number$.MODULE$.apply(package$.MODULE$.BigInt().apply(strNumber))), this.OK());
    }

    private NumberUtils.ParsingResult parseBigDecimal(String strNumber) {
        NumberUtils.ParsingResult parsingResult;
        try {
            parsingResult = new NumberUtils.ParsingResult((Option<Number>)new Some((Object)Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(strNumber))), this.OK());
        }
        catch (Exception exception) {
            parsingResult = new NumberUtils.ParsingResult((Option<Number>)None$.MODULE$, this.INVALID_DATA());
        }
        return parsingResult;
    }

    private NumberUtils$() {
        MODULE$ = this;
        this.OK = 0;
        this.OVERFLOW = 1;
        this.INVALID_DATA = 2;
    }
}

