/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.message.sse;

import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.service.http.common.message.sse.ServerSentEventImpl;

public class SseEventBuilder {
    private static final String DEFAULT_NAME = "message";
    private String eventName;
    private String id;
    private final StringBuilder eventData = new StringBuilder();
    private Long retryDelay;

    public SseEventBuilder() {
        this.reset();
    }

    public ServerSentEvent buildAndClear() {
        ServerSentEventImpl event = new ServerSentEventImpl(this.eventName, this.eventData.toString(), this.id, this.retryDelay);
        this.reset();
        return event;
    }

    public SseEventBuilder withData(String dataLine) {
        if (!this.eventData.isEmpty()) {
            this.eventData.append("\n");
        }
        this.eventData.append(dataLine);
        return this;
    }

    public SseEventBuilder withName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public SseEventBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public SseEventBuilder withRetryDelay(Long retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    private void reset() {
        this.eventName = DEFAULT_NAME;
        this.id = null;
        this.eventData.setLength(0);
        this.retryDelay = null;
    }
}

