/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class MutableMuleTraceState
implements TraceState {
    public static final String TRACE_STATE_KEY = "tracestate";
    public static final String ANCESTOR_MULE_SPAN_ID = "ancestor-mule-span-id";
    private final boolean addAncestorMuleSpanIdToTraceState;
    private final boolean propagateAllRemoteTraceContext;
    private String currentSpanId;
    private Map<String, String> remoteState;

    public static MutableMuleTraceState getMutableMuleTraceStateFrom(Map<String, String> serializeAsMap, boolean enableMuleAncestorIdManagement) {
        TraceState remoteTraceState = TraceState.getDefault();
        String traceState = serializeAsMap.get(TRACE_STATE_KEY);
        if (!StringUtils.isEmpty((CharSequence)traceState)) {
            remoteTraceState = W3CTraceContextEncoding.decodeTraceState((String)traceState);
        }
        return new MutableMuleTraceState(remoteTraceState.asMap(), remoteTraceState.get(ANCESTOR_MULE_SPAN_ID), !enableMuleAncestorIdManagement, enableMuleAncestorIdManagement);
    }

    private MutableMuleTraceState(Map<String, String> remoteState, String currentSpanId, boolean propagateAllRemoteTraceContext, boolean addAncestorMuleSpanIdToTraceState) {
        this.remoteState = remoteState;
        this.currentSpanId = currentSpanId;
        this.propagateAllRemoteTraceContext = propagateAllRemoteTraceContext;
        this.addAncestorMuleSpanIdToTraceState = addAncestorMuleSpanIdToTraceState;
    }

    public String get(String key) {
        return this.remoteState.get(key);
    }

    public int size() {
        return this.remoteState.size();
    }

    public boolean isEmpty() {
        if (this.currentSpanId != null) {
            return false;
        }
        return this.remoteState.isEmpty();
    }

    public void forEach(BiConsumer<String, String> biConsumer) {
        this.remoteState.forEach((? super K key, ? super V value) -> {
            if (this.propagateAllRemoteTraceContext || !key.equals(ANCESTOR_MULE_SPAN_ID)) {
                biConsumer.accept((String)key, (String)value);
            }
        });
        if (this.currentSpanId != null && this.addAncestorMuleSpanIdToTraceState) {
            biConsumer.accept(ANCESTOR_MULE_SPAN_ID, this.currentSpanId);
        }
    }

    public Map<String, String> asMap() {
        HashMap<String, String> mapWithAncestor = new HashMap<String, String>();
        this.forEach(mapWithAncestor::put);
        return mapWithAncestor;
    }

    public TraceStateBuilder toBuilder() {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String value) {
        this.remoteState.put(key, value);
    }

    public TraceState withAncestor(String ancestorSpanId) {
        return new MutableMuleTraceState(this.remoteState, ancestorSpanId, this.propagateAllRemoteTraceContext, this.addAncestorMuleSpanIdToTraceState);
    }

    public void propagateRemoteContext(MutableMuleTraceState targetMuleTraceState) {
        targetMuleTraceState.remoteState = this.remoteState;
    }
}

