/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import jakarta.transaction.Transaction;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.transaction.TransactionAdapter;
import org.mule.runtime.core.internal.transaction.xa.IllegalTransactionStateException;
import org.mule.runtime.core.internal.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements TransactionAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransaction.class);
    protected String id = UUID.getUUID();
    protected int timeout;
    private Instant beginTime;
    protected ComponentLocation componentLocation;
    protected String applicationName;
    protected final NotificationDispatcher notificationFirer;
    protected boolean rollbackAfterTimeout;

    protected AbstractTransaction(String applicationName, NotificationDispatcher notificationFirer) {
        this.applicationName = applicationName;
        this.notificationFirer = notificationFirer;
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        int status = this.getStatus();
        return status == 1 || status == 4 || status == 9;
    }

    @Override
    public boolean isBegun() throws TransactionException {
        int status = this.getStatus();
        return status != 6 && status != 5;
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.getStatus() == 4;
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.getStatus() == 3;
    }

    @Override
    public void begin() throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Beginning transaction {}@{}", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
        }
        this.doBegin();
        TransactionCoordination.getInstance().bindTransaction(this);
        this.fireNotification(new TransactionNotification(this.getId(), 1201, this.getApplicationName()));
        this.beginTime = Instant.now();
    }

    @Override
    public void commit() throws TransactionException {
        boolean timeoutReached = this.timeoutReached();
        try {
            if (this.isRollbackOnly()) {
                throw new IllegalTransactionStateException(CoreMessages.transactionMarkedForRollback());
            }
            if (this.rollbackAfterTimeout && timeoutReached) {
                this.rollback();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Committing transaction {}@{}", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
            }
            this.doCommit();
            this.fireNotification(new TransactionNotification(this.getId(), 1202, this.getApplicationName()));
        }
        finally {
            this.unbindTransaction();
        }
    }

    private boolean timeoutReached() {
        return this.timeout > 0 && Duration.between(this.beginTime, Instant.now()).toMillis() > (long)this.timeout;
    }

    @Override
    public void rollback() throws TransactionException {
        boolean timeoutReached = this.timeoutReached();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Rolling back transaction {}@{}", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
            }
            this.setRollbackOnly();
            this.doRollback();
            this.fireNotification(new TransactionNotification(this.getId(), 1203, this.getApplicationName()));
            if (this.rollbackAfterTimeout && timeoutReached) {
                throw new TransactionException(I18nMessageFactory.createStaticMessage((String)"Timeout Reached. Transaction rolled back."), (Throwable)new TimeoutException(MessageFormat.format("Execution time for transaction exceeded timeout ({0} ms)", this.timeout)));
            }
        }
        finally {
            this.unbindTransaction();
        }
    }

    protected void unbindTransaction() throws TransactionException {
        TransactionCoordination.getInstance().unbindTransaction(this);
    }

    protected abstract void doBegin() throws TransactionException;

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected void fireNotification(TransactionNotification notification) {
        this.notificationFirer.dispatch((Notification)notification);
    }

    @Override
    public boolean isXA() {
        return false;
    }

    @Override
    public void resume() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public Transaction suspend() throws TransactionException {
        throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        int status;
        try {
            status = this.getStatus();
        }
        catch (TransactionException e) {
            status = -1;
        }
        return MessageFormat.format("{0}[id={1} , status={2}]", this.getClass().getName(), this.id, status);
    }

    private String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    @Override
    public void setRollbackIfTimeout(boolean rollbackAfterTimeout) {
        this.rollbackAfterTimeout = rollbackAfterTimeout;
    }

    @Override
    public Optional<ComponentLocation> getComponentLocation() {
        return Optional.ofNullable(this.componentLocation);
    }
}

