/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        return IOUtils.getResourceAsStream(resourceName, callingClass, true, true);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) throws IOException {
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass, tryAsFile, tryAsUrl);
        if (url == null) {
            return null;
        }
        return org.mule.runtime.api.util.IOUtils.getInputStreamWithCacheControl((URL)url);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = new File(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug("Unable to load resource from the file system: {}", (Object)file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource from the file system: {}", (Object)e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(() -> {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return cl != null ? cl.getResource(resourceName) : null;
                });
                if (url == null) {
                    logger.debug("Unable to load resource {} from the classpath", (Object)resourceName);
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource {} from the classpath: {}", (Object)resourceName, (Object)e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    private IOUtils() {
    }
}

