/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

public final class HttpEntityMatcher
extends TypeSafeMatcher<HttpEntity> {
    private final Matcher<String> contentStringMatcher;

    public static Matcher<HttpEntity> hasContent(Matcher<String> contentStringMatcher) {
        return new HttpEntityMatcher(contentStringMatcher);
    }

    private HttpEntityMatcher(Matcher<String> contentStringMatcher) {
        this.contentStringMatcher = contentStringMatcher;
    }

    protected boolean matchesSafely(HttpEntity item) {
        String contentAsString;
        try {
            contentAsString = IOUtils.toString((InputStream)item.getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return false;
        }
        return this.contentStringMatcher.matches((Object)contentAsString);
    }

    public void describeTo(Description description) {
        description.appendText("A content matching: ");
        this.contentStringMatcher.describeTo(description);
    }

    protected void describeMismatchSafely(HttpEntity item, Description mismatchDescription) {
        try {
            String contentAsString = IOUtils.toString((InputStream)item.getContent(), (Charset)StandardCharsets.UTF_8);
            mismatchDescription.appendText("Content was: '").appendText(contentAsString).appendText("'");
        }
        catch (IOException e) {
            mismatchDescription.appendText(e.toString());
        }
    }
}

