/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.routing.FirstSuccessfulRouter;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;

public class FirstSuccessful
extends AbstractComponent
implements Router,
Lifecycle,
MuleContextAware {
    public static final String FIRST_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFFIX = ":attempt:";
    private final List<ProcessorRoute> routes = new ArrayList<ProcessorRoute>();
    private MuleContext muleContext;
    @Inject
    private ComponentTracerFactory componentTracerFactory;

    public void initialise() throws InitialisationException {
        Long routeNumber = 1L;
        for (ProcessorRoute route : this.routes) {
            route.setMessagingExceptionHandler(null);
            route.setComponentTracer(this.componentTracerFactory.fromComponent((Component)this, FIRST_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFFIX + routeNumber));
            LifecycleUtils.initialiseIfNeeded((Object)((Object)route), (MuleContext)this.muleContext);
            Long l = routeNumber;
            routeNumber = routeNumber + 1L;
        }
    }

    public void start() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.start();
        }
    }

    public void stop() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.stop();
        }
    }

    public void dispose() {
        for (ProcessorRoute route : this.routes) {
            route.dispose();
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public void addRoute(Processor processor) {
        this.routes.add(new ProcessorRoute(processor, this.componentTracerFactory));
    }

    public void setRoutes(Collection<Processor> routes) {
        routes.forEach(this::addRoute);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return new FirstSuccessfulRouter((Component)this, publisher, this.routes).getDownstreamPublisher();
    }
}

