/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;

public class EchoFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(EchoFilter.class);

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        Connection connection = ctx.getConnection();
        Object address = ctx.getAddress();
        if (logger.isTraceEnabled()) {
            logger.trace("EchoFilter. connection={} dstAddress={} message={}", new Object[]{connection, address, message});
        }
        if (message instanceof Buffer) {
            ((Buffer)message).allowBufferDispose(true);
        }
        ctx.write(address, message, null);
        return ctx.getStopAction();
    }
}

