/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.avro;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.mule.weave.v2.core.exception.MissingRequiredSettingException;
import org.mule.weave.v2.core.exception.SchemaNotFoundException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.avro.AvroDataFormat;
import org.mule.weave.v2.module.avro.AvroSettings;
import org.mule.weave.v2.module.avro.AvroWriter$;
import org.mule.weave.v2.module.avro.ConversionFactory$;
import org.mule.weave.v2.module.avro.exception.AvroInvalidTypeException;
import org.mule.weave.v2.module.avro.exception.InvalidEnumValueException;
import org.mule.weave.v2.module.avro.exception.InvalidFieldNameException;
import org.mule.weave.v2.module.avro.exception.InvalidFieldValueException;
import org.mule.weave.v2.module.avro.exception.InvalidValueForUnionException;
import org.mule.weave.v2.module.avro.exception.InvalidValueLogicalTypeException;
import org.mule.weave.v2.module.avro.exception.InvalidValueTypeException;
import org.mule.weave.v2.module.avro.exception.MissingRequiredFieldException;
import org.mule.weave.v2.module.avro.exception.UnableToConvertTypeException;
import org.mule.weave.v2.module.option.ConfigurableSchemaSetting;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u000b\u0016\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011)\u0019!C\u0001s!Aa\b\u0001B\u0001B\u0003%!\b\u0003\u0005@\u0001\t\u0005\t\u0015a\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0011\u0006\u0001\"\u0011O\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002v\u0001!\t&a\u001e\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBA^\u0001\u0011\u0005\u0013QX\u0004\b\u00037,\u0002\u0012AAo\r\u0019!R\u0003#\u0001\u0002`\"1a)\u0005C\u0001\u0003CDq!a9\u0012\t\u0003\t)O\u0001\u0006BmJ|wK]5uKJT!AF\f\u0002\t\u00054(o\u001c\u0006\u00031e\ta!\\8ek2,'B\u0001\u000e\u001c\u0003\t1(G\u0003\u0002\u001d;\u0005)q/Z1wK*\u0011adH\u0001\u0005[VdWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051:\u0012AB<sSR,'/\u0003\u0002/W\t1qK]5uKJ\f!a\\:\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014AA5p\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0011M,G\u000f^5oON,\u0012A\u000f\t\u0003wqj\u0011!F\u0005\u0003{U\u0011A\"\u0011<s_N+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u0007\r$\b\u0010\u0005\u0002B\t6\t!I\u0003\u0002D3\u0005)Qn\u001c3fY&\u0011QI\u0011\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002I\u00172#\"!\u0013&\u0011\u0005m\u0002\u0001\"B \u0006\u0001\b\u0001\u0005\"B\u0018\u0006\u0001\u0004\u0001\u0004\"\u0002\u001d\u0006\u0001\u0004Q\u0014!\u00024mkNDG#A(\u0011\u0005\u0011\u0002\u0016BA)&\u0005\u0011)f.\u001b;\u0002\u000b\rdwn]3\u0002\u0017]\u0014\u0018\u000e^3PE*,7\r\u001e\u000b\u0004+jCGC\u0001,Z!\t!s+\u0003\u0002YK\t\u0019\u0011I\\=\t\u000b}B\u00019\u0001!\t\u000bmC\u0001\u0019\u0001/\u0002\u0003Y\u00042!\u00181c\u001b\u0005q&BA0C\u0003\u00191\u0018\r\\;fg&\u0011\u0011M\u0018\u0002\u0006-\u0006dW/\u001a\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\n\u000b\u0011b\u001d;sk\u000e$XO]3\n\u0005\u001d$'!C(cU\u0016\u001cGoU3r\u0011\u0015I\u0007\u00021\u0001k\u0003\u0019\u00198\r[3nCB\u00111n\\\u0007\u0002Y*\u0011a#\u001c\u0006\u0003]~\ta!\u00199bG\",\u0017B\u00019m\u0005\u0019\u00196\r[3nC\u0006QqO]5uK\u0006\u0013(/Y=\u0015\tM|\u00181\u0002\u000b\u0003iz\u00042!^>W\u001d\t1\u00180D\u0001x\u0015\tAH.A\u0004hK:,'/[2\n\u0005i<\u0018aC$f]\u0016\u0014\u0018n\u0019#bi\u0006L!\u0001`?\u0003\u000b\u0005\u0013(/Y=\u000b\u0005i<\b\"B \n\u0001\b\u0001\u0005bBA\u0001\u0013\u0001\u0007\u00111A\u0001\u0006m\u0006dW/\u001a\t\u0005;\u0002\f)\u0001E\u0002d\u0003\u000fI1!!\u0003e\u0005!\t%O]1z'\u0016\f\b\"B5\n\u0001\u0004Q\u0017!B<sSR,GCBA\t\u0003+\tY\u0003F\u0002W\u0003'AQa\u0010\u0006A\u0004\u0001Cq!!\u0001\u000b\u0001\u0004\t9\u0002\r\u0003\u0002\u001a\u0005}\u0001\u0003B/a\u00037\u0001B!!\b\u0002 1\u0001A\u0001DA\u0011\u0003+\t\t\u0011!A\u0003\u0002\u0005\r\"aA0%cE\u0019\u0011Q\u0005,\u0011\u0007\u0011\n9#C\u0002\u0002*\u0015\u0012qAT8uQ&tw\rC\u0003j\u0015\u0001\u0007!.\u0001\td_:4XM\u001d;U_J\u000bw\u000fV=qKV!\u0011\u0011GA()5\u0019\u00131GA\u001c\u0003s\t\u0019%a\u0015\u0002d!1\u0011QG\u0006A\u0002Y\u000bQ\u0001Z1uk6DQ![\u0006A\u0002)Dq!a\u000f\f\u0001\u0004\ti$A\u0006m_\u001eL7-\u00197UsB,\u0007cA6\u0002@%\u0019\u0011\u0011\t7\u0003\u00171{w-[2bYRK\b/\u001a\u0005\b\u0003\u000bZ\u0001\u0019AA$\u0003)\u0019wN\u001c<feNLwN\u001c\t\u0006W\u0006%\u0013QJ\u0005\u0004\u0003\u0017b'AC\"p]Z,'o]5p]B!\u0011QDA(\t\u001d\t\tf\u0003b\u0001\u0003G\u0011\u0011\u0001\u0016\u0005\b\u0003+Z\u0001\u0019AA,\u0003%1\u0018\r\\;f)f\u0004X\r\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFQ\u0001\u0006if\u0004Xm]\u0005\u0005\u0003C\nYF\u0001\u0003UsB,\u0007bBA3\u0017\u0001\u0007\u0011qM\u0001\tY>\u001c\u0017\r^5p]B!\u0011\u0011NA9\u001b\t\tYG\u0003\u0003\u0002f\u00055$bAA83\u00051\u0001/\u0019:tKJLA!a\u001d\u0002l\tAAj\\2bi&|g.\u0001\u0007e_^\u0013\u0018\u000e^3WC2,X\r\u0006\u0003\u0002z\u0005uDcA(\u0002|!)q\b\u0004a\u0002\u0001\"9\u0011\u0011\u0001\u0007A\u0002\u0005}\u0004\u0007BAA\u0003\u000b\u0003B!\u00181\u0002\u0004B!\u0011QDAC\t1\t9)! \u0002\u0002\u0003\u0005)\u0011AA\u0012\u0005\ryFeN\u0001\u001aSN\u0004&/[7ji&4X\rV=qK\u000e{W\u000e]1uS\ndW\r\u0006\u0004\u0002\u000e\u0006M\u0015Q\u0017\t\u0004I\u0005=\u0015bAAIK\t9!i\\8mK\u0006t\u0007bBAK\u001b\u0001\u0007\u0011qS\u0001\u000bg\u000eDW-\\1UsB,\u0007\u0003BAM\u0003csA!a'\u0002.:!\u0011QTAV\u001d\u0011\ty*!+\u000f\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*\"\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002o?%\u0011a#\\\u0005\u0004\u0003_c\u0017AB*dQ\u0016l\u0017-\u0003\u0003\u0002b\u0005M&bAAXY\"1\u0011\u0011A\u0007A\u0002Y\u000baA]3tk2$X#\u0001,\u0002\u0015\u0011\fG/\u0019$pe6\fG/\u0006\u0002\u0002@B)A%!1\u0002F&\u0019\u00111Y\u0013\u0003\r=\u0003H/[8oa\u0019\t9-!5\u0002XBA\u0011\u0011ZAf\u0003\u001f\f).D\u0001\u0018\u0013\r\tim\u0006\u0002\u000b\t\u0006$\u0018MR8s[\u0006$\b\u0003BA\u000f\u0003#$1\"a5\u0010\u0003\u0003\u0005\tQ!\u0001\u0002$\t!q\fJ\u00191!\u0011\ti\"a6\u0005\u0017\u0005ew\"!A\u0001\u0002\u000b\u0005\u00111\u0005\u0002\u0005?\u0012\n\u0014'\u0001\u0006BmJ|wK]5uKJ\u0004\"aO\t\u0014\u0005E\u0019CCAAo\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t9/a;\u0002vR\u0019\u0011*!;\t\u000b}\u001a\u00029\u0001!\t\u000f\u000558\u00031\u0001\u0002p\u0006\u0011A\u000f\u001d\t\u0004U\u0005E\u0018bAAzW\tqA+\u0019:hKR\u0004&o\u001c<jI\u0016\u0014\b\"\u0002\u001d\u0014\u0001\u0004Q\u0004")
public class AvroWriter
implements Writer {
    private final OutputStream os;
    private final AvroSettings settings;

    public static AvroWriter apply(TargetProvider targetProvider, AvroSettings avroSettings, EvaluationContext evaluationContext) {
        return AvroWriter$.MODULE$.apply(targetProvider, avroSettings, evaluationContext);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public AvroSettings settings() {
        return this.settings;
    }

    public void flush() {
    }

    public void close() {
    }

    public Object writeObject(Value<ObjectSeq> v, Schema schema, EvaluationContext ctx) {
        ObjectSeq objectSeq = (ObjectSeq)v.evaluate(ctx);
        Schema.Type type = schema.getType();
        if (Schema.Type.MAP.equals(type)) {
            HashMap map = new HashMap();
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
                return map.put(name, this.write(kvp._2(), schema.getValueType(), ctx));
            });
            return map;
        }
        if (Schema.Type.RECORD.equals(type)) {
            GenericData.Record record = new GenericData.Record(schema);
            Schema.Field[] processedFields = new Schema.Field[schema.getFields().size()];
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                AvroWriter.$anonfun$writeObject$2(this, ctx, schema, record, processedFields, kvp);
                return BoxedUnit.UNIT;
            });
            schema.getFields().forEach(missingField -> {
                if (processedFields[missingField.pos()] == null) {
                    if (missingField.defaultVal() != null) {
                        record.put(missingField.pos(), missingField.defaultVal());
                        return;
                    }
                    Schema fieldSchema = missingField.schema();
                    throw new MissingRequiredFieldException(missingField.name(), fieldSchema.getType().name().toLowerCase(), schema.getFullName(), v.location());
                }
            });
            return record;
        }
        throw new InvalidValueTypeException(v.valueType(ctx), type, v.location());
    }

    public GenericData.Array<Object> writeArray(Value<ArraySeq> value, Schema schema, EvaluationContext ctx) {
        Schema.Type type = schema.getType();
        if (Schema.Type.ARRAY.equals(type)) {
            Value[] evaluate = ((ArraySeq)value.evaluate(ctx)).toArray();
            Schema elementType = schema.getElementType();
            GenericData.Array result = new GenericData.Array(evaluate.length, schema);
            for (int i = 0; i < evaluate.length; ++i) {
                result.add(this.write(evaluate[i], elementType, ctx));
            }
            return result;
        }
        throw new InvalidValueTypeException((Type)ArrayType$.MODULE$, type, value.location());
    }

    public Object write(Value<?> value, Schema schema, EvaluationContext ctx) {
        Schema.Type type = schema.getType();
        if (Schema.Type.UNION.equals(type)) {
            Value materializedValue = value.materialize(ctx);
            List types = schema.getTypes();
            IntRef i = IntRef.create((int)0);
            ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            None$ result = None$.MODULE$;
            while (result.isEmpty() && i.elem < types.size()) {
                Try writeResult = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.write(materializedValue, (Schema)types.get(i$1.elem), ctx));
                Try try_ = writeResult;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    exceptions.$plus$eq((Object)exception);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object value2 = success.value();
                    result = new Some(value2);
                } else {
                    throw new MatchError((Object)try_);
                }
                ++i.elem;
            }
            None$ none$ = result;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                Object v = some.value();
                return v;
            }
            if (None$.MODULE$.equals(none$)) {
                throw new InvalidValueForUnionException((Seq<Throwable>)exceptions, value.location(), (Seq<Schema.Type>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(types).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())), value.valueType(ctx));
            }
            throw new MatchError((Object)none$);
        }
        Value<?> value3 = value;
        if (ObjectType$.MODULE$.accepts(value3, ctx)) {
            return this.writeObject((Value<ObjectSeq>)ObjectType$.MODULE$.coerce(value, ctx), schema, ctx);
        }
        if (ArrayType$.MODULE$.accepts(value3, ctx)) {
            return this.writeArray((Value<ArraySeq>)ArrayType$.MODULE$.coerce(value, ctx), schema, ctx);
        }
        if (RangeType$.MODULE$.accepts(value3, ctx)) {
            return this.writeArray((Value<ArraySeq>)ArrayType$.MODULE$.coerce(value, ctx), schema, ctx);
        }
        Schema.Type type2 = schema.getType();
        if (Schema.Type.LONG.equals(type2)) {
            Option<Conversion<?>> maybeConversion = ConversionFactory$.MODULE$.getConversion(schema.getLogicalType());
            Option<Conversion<?>> option = maybeConversion;
            if (option instanceof Some) {
                Value<?> value4;
                String string;
                Some some = (Some)option;
                Conversion conversion = (Conversion)some.value();
                String string2 = schema.getLogicalType().getName();
                Object avroValue = string2 != null && (string = string2).startsWith("timestamp") ? (DateTimeType$.MODULE$.accepts(value4 = value, ctx) ? ((ChronoZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInstant() : ((ChronoLocalDateTime)LocalDateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInstant(ZoneOffset.UTC)) : value.evaluate(ctx);
                return this.convertToRawType(avroValue, schema, schema.getLogicalType(), conversion, value.valueType(ctx), value.location());
            }
            if (None$.MODULE$.equals(option)) {
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toLong());
                if (try_ instanceof Failure) {
                    throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.LONG, value.location());
                }
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    long value5 = BoxesRunTime.unboxToLong((Object)success.value());
                    return BoxesRunTime.boxToLong((long)value5);
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError(option);
        }
        if (Schema.Type.INT.equals(type2)) {
            Option<Conversion<?>> maybeConversion = ConversionFactory$.MODULE$.getConversion(schema.getLogicalType());
            Option<Conversion<?>> option = maybeConversion;
            if (option instanceof Some) {
                Some some = (Some)option;
                Conversion conversion = (Conversion)some.value();
                return this.convertToRawType(value.evaluate(ctx), schema, schema.getLogicalType(), conversion, value.valueType(ctx), value.location());
            }
            if (None$.MODULE$.equals(option)) {
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInt());
                if (try_ instanceof Failure) {
                    throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.INT, value.location());
                }
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    int value6 = BoxesRunTime.unboxToInt((Object)success.value());
                    return BoxesRunTime.boxToInteger((int)value6);
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError(option);
        }
        if (Schema.Type.FLOAT.equals(type2)) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toFloat());
            if (try_ instanceof Failure) {
                throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.FLOAT, value.location());
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                float value7 = BoxesRunTime.unboxToFloat((Object)success.value());
                return BoxesRunTime.boxToFloat((float)value7);
            }
            throw new MatchError((Object)try_);
        }
        if (Schema.Type.DOUBLE.equals(type2)) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toDouble());
            if (try_ instanceof Failure) {
                throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.DOUBLE, value.location());
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                double value8 = BoxesRunTime.unboxToDouble((Object)success.value());
                return BoxesRunTime.boxToDouble((double)value8);
            }
            throw new MatchError((Object)try_);
        }
        if (Schema.Type.BOOLEAN.equals(type2)) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx)));
            if (try_ instanceof Failure) {
                throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.BOOLEAN, value.location());
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                boolean value9 = BoxesRunTime.unboxToBoolean((Object)success.value());
                return BoxesRunTime.boxToBoolean((boolean)value9);
            }
            throw new MatchError((Object)try_);
        }
        if (Schema.Type.STRING.equals(type2)) {
            Option<Conversion<?>> maybeConversion = ConversionFactory$.MODULE$.getConversion(schema.getLogicalType());
            Option<Conversion<?>> option = maybeConversion;
            if (option instanceof Some) {
                Some some = (Some)option;
                Conversion conversion = (Conversion)some.value();
                String string = schema.getLogicalType().getName();
                if (string != null) {
                    String string3;
                    String string4 = string3 = string;
                    String string5 = LogicalTypes.uuid().getName();
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
                        if (try_ instanceof Failure) {
                            throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.STRING, value.location());
                        }
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            CharSequence evaluatedValue = (CharSequence)success.value();
                            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> UUID.fromString(((Object)evaluatedValue).toString()));
                            if (try_2 instanceof Failure) {
                                throw new InvalidValueLogicalTypeException(((Object)evaluatedValue).toString(), LogicalTypes.uuid(), value.location());
                            }
                            return evaluatedValue;
                        }
                        throw new MatchError((Object)try_);
                    }
                }
                return this.convertToRawType(value.evaluate(ctx), schema, schema.getLogicalType(), conversion, value.valueType(ctx), value.location());
            }
            if (None$.MODULE$.equals(option)) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
                if (try_ instanceof Failure) {
                    throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.STRING, value.location());
                }
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    CharSequence value10 = (CharSequence)success.value();
                    return value10;
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError(option);
        }
        if (Schema.Type.BYTES.equals(type2)) {
            Option<Conversion<?>> maybeConversion = ConversionFactory$.MODULE$.getConversion(schema.getLogicalType());
            Option<Conversion<?>> option = maybeConversion;
            if (option instanceof Some) {
                Some some = (Some)option;
                Conversion conversion = (Conversion)some.value();
                BigDecimal bigDecimal = ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toBigDecimal().bigDecimal();
                return this.convertToRawType(bigDecimal, schema, schema.getLogicalType(), conversion, value.valueType(ctx), value.location());
            }
            return ByteBuffer.wrap(BinaryValue$.MODULE$.getBytes(BinaryType$.MODULE$.coerce(value, ctx), BinaryValue$.MODULE$.getBytes$default$2(), ctx));
        }
        if (Schema.Type.ENUM.equals(type2)) {
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            if (try_ instanceof Failure) {
                throw new InvalidValueTypeException(value.valueType(ctx), Schema.Type.ENUM, value.location());
            }
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                CharSequence value11 = (CharSequence)success.value();
                if (schema.getEnumSymbols().contains(value11)) {
                    return new GenericData.EnumSymbol(schema, (Object)value11);
                }
            }
            if (bl) {
                CharSequence strValue = (CharSequence)success.value();
                throw new InvalidEnumValueException(((Object)strValue).toString(), (String[])schema.getEnumSymbols().toArray((Object[])new String[0]), value.location());
            }
            throw new MatchError((Object)try_);
        }
        if (Schema.Type.FIXED.equals(type2)) {
            Option<Conversion<?>> maybeConversion = ConversionFactory$.MODULE$.getConversion(schema.getLogicalType());
            Option<Conversion<?>> option = maybeConversion;
            if (option instanceof Some) {
                Some some = (Some)option;
                Conversion conversion = (Conversion)some.value();
                BigDecimal bigDecimal = ((Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toBigDecimal().bigDecimal();
                return this.convertToRawType(bigDecimal, schema, schema.getLogicalType(), conversion, value.valueType(ctx), value.location());
            }
            byte[] bytes = BinaryValue$.MODULE$.getBytes(BinaryType$.MODULE$.coerce(value, ctx), BinaryValue$.MODULE$.getBytes$default$2(), ctx);
            return new GenericData.Fixed(schema, bytes);
        }
        if (Schema.Type.NULL.equals(type2)) {
            return NullType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        }
        throw new InvalidValueTypeException(value.valueType(ctx), type2, value.location());
    }

    public <T> Object convertToRawType(Object datum, Schema schema, LogicalType logicalType, Conversion<T> conversion, Type valueType, Location location) {
        Object object;
        try {
            object = Conversions.convertToRawType((Object)datum, (Schema)schema, (LogicalType)logicalType, conversion);
        }
        catch (AvroRuntimeException avroRuntimeException) {
            throw new UnableToConvertTypeException(valueType, datum.getClass(), conversion.getConvertedType(), logicalType.getName(), location);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnableToConvertTypeException(valueType, datum.getClass(), conversion.getConvertedType(), logicalType.getName(), location);
        }
        return object;
    }

    public void doWriteValue(Value<?> value2, EvaluationContext ctx) {
        ConfigurableSchemaSetting.Result result;
        block18: {
            ConfigurableSchemaSetting.Result result2;
            ConfigurableSchemaSetting.Result result3;
            Option<ConfigurableSchemaSetting.Result> option;
            Some some;
            boolean bl;
            block17: {
                bl = false;
                some = null;
                option = this.settings().schema();
                if (!(option instanceof Some)) break block17;
                bl = true;
                some = (Some)option;
                result = (ConfigurableSchemaSetting.Result)some.value();
                if (result instanceof ConfigurableSchemaSetting.SchemaResult) break block18;
            }
            if (bl && (result3 = (ConfigurableSchemaSetting.Result)some.value()) instanceof ConfigurableSchemaSetting.SchemaNotSet) {
                throw new MissingRequiredSettingException("schemaUrl", "Avro Writer", value2.location());
            }
            if (bl && (result2 = (ConfigurableSchemaSetting.Result)some.value()) instanceof ConfigurableSchemaSetting.SchemaNotFound) {
                ConfigurableSchemaSetting.SchemaNotFound schemaNotFound = (ConfigurableSchemaSetting.SchemaNotFound)result2;
                String schemaUrl = schemaNotFound.path();
                throw new SchemaNotFoundException(value2.location(), schemaUrl);
            }
            if (None$.MODULE$.equals(option)) {
                throw new MissingRequiredSettingException("schemaUrl", "Avro Writer", value2.location());
            }
            throw new MatchError(option);
        }
        ConfigurableSchemaSetting.SchemaResult schemaResult = (ConfigurableSchemaSetting.SchemaResult)result;
        byte[] resultSchema = schemaResult.result();
        byte[] schemaResult2 = resultSchema;
        Schema schema = new Schema.Parser().parse((InputStream)new ByteArrayInputStream(schemaResult2));
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
            dataFileWriter.create(schema, this.os);
            Value<?> value3 = value2;
            if (ObjectType$.MODULE$.accepts(value3, ctx)) {
                Object result4 = this.write(value2, schema, ctx);
                Object object = result4;
                if (!(object instanceof GenericRecord)) {
                    throw new InvalidValueTypeException(value2.valueType(ctx), schema.getType(), value2.location());
                }
                GenericRecord genericRecord = (GenericRecord)object;
                dataFileWriter.append((Object)genericRecord);
            } else if (ArrayType$.MODULE$.accepts(value3, ctx)) {
                Iterator iterator = ((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator();
                iterator.foreach((Function1 & Serializable & scala.Serializable)value -> {
                    AvroWriter.$anonfun$doWriteValue$1(this, schema, ctx, dataFileWriter, value);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(value3);
            }
            dataFileWriter.flush();
            dataFileWriter.close();
            return;
        }
        if (Schema.Type.ARRAY.equals(type)) {
            Object result5 = this.write(value2, schema, ctx);
            Object object = result5;
            if (!(object instanceof GenericData.Array)) {
                throw new InvalidValueTypeException(value2.valueType(ctx), schema.getType(), value2.location());
            }
            GenericData.Array array = (GenericData.Array)object;
            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
            dataFileWriter.create(schema, this.os);
            dataFileWriter.append((Object)array);
            dataFileWriter.flush();
            dataFileWriter.close();
            return;
        }
        if (Schema.Type.NULL.equals(type) ? true : (Schema.Type.BOOLEAN.equals(type) ? true : (Schema.Type.INT.equals(type) ? true : (Schema.Type.LONG.equals(type) ? true : (Schema.Type.FLOAT.equals(type) ? true : (Schema.Type.DOUBLE.equals(type) ? true : (Schema.Type.STRING.equals(type) ? true : Schema.Type.BYTES.equals(type)))))))) {
            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
            DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
            dataFileWriter.create(schema, this.os);
            Value<?> value4 = value2;
            if (ArrayType$.MODULE$.accepts(value4, ctx)) {
                Iterator iterator = ((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator();
                iterator.foreach((Function1 & Serializable & scala.Serializable)v -> {
                    AvroWriter.$anonfun$doWriteValue$2(this, schema, ctx, dataFileWriter, v);
                    return BoxedUnit.UNIT;
                });
            } else {
                Object result6 = this.write(value2, schema, ctx);
                dataFileWriter.append(result6);
            }
            dataFileWriter.flush();
            dataFileWriter.close();
            return;
        }
        throw new InvalidValueTypeException(value2.valueType(ctx), type, value2.location());
    }

    private boolean isPrimitiveTypeCompatible(Schema.Type schemaType, Object value) {
        Schema.Type type = schemaType;
        if (Schema.Type.NULL.equals(type)) {
            return value == null;
        }
        return ((Class)ConversionFactory$.MODULE$.typeToClassMap().getOrElse((Object)schemaType, (Function0 & Serializable & scala.Serializable)() -> Void.class)).isInstance(value);
    }

    public Object result() {
        return this.os;
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new AvroDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeObject$2(AvroWriter $this, EvaluationContext ctx$1, Schema schema$1, GenericData.Record record$1, Schema.Field[] processedFields$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$1)).name();
        Schema.Field field = schema$1.getField(name);
        if (field == null) {
            throw new InvalidFieldNameException(name, (Seq<String>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Buffer$.MODULE$.canBuildFrom())), kvp._1().location());
        }
        try {
            Object value = $this.write(kvp._2(), field.schema(), ctx$1);
            record$1.put(name, value);
            processedFields$1[field.pos()] = field;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AvroInvalidTypeException) {
                AvroInvalidTypeException avroInvalidTypeException = (AvroInvalidTypeException)((Object)throwable2);
                throw new InvalidFieldValueException(name, avroInvalidTypeException.message(), kvp._1().location());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(AvroWriter $this, Schema schema$2, EvaluationContext ctx$3, DataFileWriter dataFileWriter$1, Value value) {
        Object result = $this.write(value, schema$2, ctx$3);
        Object object = result;
        if (object instanceof GenericRecord) {
            GenericRecord genericRecord = (GenericRecord)object;
            dataFileWriter$1.append((Object)genericRecord);
            return;
        }
        throw new InvalidValueTypeException(value.valueType(ctx$3), schema$2.getType(), value.location());
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$2(AvroWriter $this, Schema schema$2, EvaluationContext ctx$3, DataFileWriter dataFileWriter$2, Value v) {
        Object result;
        Object object = result = $this.write(v, schema$2, ctx$3);
        if ($this.isPrimitiveTypeCompatible(schema$2.getType(), object)) {
            dataFileWriter$2.append(object);
            return;
        }
        throw new InvalidValueTypeException(v.valueType(ctx$3), schema$2.getType(), v.location());
    }

    public AvroWriter(OutputStream os, AvroSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

