/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class BaseExceptionHandler
implements FlowExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExceptionHandler.class);

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        this.onError(exception);
        throw new RuntimeException(exception);
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        this.onError(exception);
        return Mono.error((Throwable)exception);
    }

    protected abstract void onError(Exception var1);

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, Consumer<CoreEvent> continueCallback, Consumer<Throwable> propagateCallback) {
        final Consumer<Exception> router = FlowExceptionHandler.super.router(publisherPostProcessor, continueCallback, propagateCallback);
        return new ExceptionRouter(){

            @Override
            public void accept(Exception error) {
                LOGGER.debug("Routing error {} in '{}'...", (Object)error, (Object)BaseExceptionHandler.this);
                BaseExceptionHandler.this.onError(error);
                router.accept(error);
            }

            public void dispose() {
                LifecycleUtils.disposeIfNeeded(router, LOGGER);
            }
        };
    }
}

