/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.simple.SerializableToByteArray;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class ObjectToInputStream
extends SerializableToByteArray {
    public ObjectToInputStream() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.setReturnDataType(DataType.INPUT_STREAM);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return new ByteArrayInputStream(((String)src).getBytes(encoding));
            }
            if (src instanceof CursorStreamProvider) {
                return ((CursorStreamProvider)src).openCursor();
            }
            if (src instanceof byte[]) {
                return new ByteArrayInputStream((byte[])src);
            }
            if (src instanceof OutputHandler) {
                OutputHandler oh = (OutputHandler)src;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                oh.write(PrivilegedEvent.getCurrentEvent(), out);
                return new ByteArrayInputStream(out.toByteArray());
            }
            return new ByteArrayInputStream((byte[])super.doTransform(src, encoding));
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }
}

