/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.management.stats.DefaultFlowsSummaryStatistics;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultFlowBuilder
implements Flow.Builder {
    private final String name;
    private final MuleContext muleContext;
    private final ComponentInitialStateManager componentInitialStateManager;
    private MessageSource source;
    private List<Processor> processors = Collections.emptyList();
    private FlowExceptionHandler exceptionListener;
    private ProcessingStrategyFactory processingStrategyFactory;
    private String initialState = "started";
    private Integer maxConcurrency;
    private DefaultFlow flow;

    public DefaultFlowBuilder(String name, MuleContext muleContext, ComponentInitialStateManager componentInitialStateManager) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (String)"name cannot be empty");
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        Preconditions.checkArgument((componentInitialStateManager != null ? 1 : 0) != 0, (String)"componentInitialStateManager cannot be null");
        this.componentInitialStateManager = componentInitialStateManager;
        this.name = name;
        this.muleContext = muleContext;
    }

    @Override
    public Flow.Builder source(MessageSource source) {
        this.checkImmutable();
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (String)"source cannot be null");
        this.source = source;
        return this;
    }

    @Override
    public Flow.Builder processors(List<Processor> processors) {
        this.checkImmutable();
        Preconditions.checkArgument((processors != null ? 1 : 0) != 0, (String)"processors cannot be null");
        this.processors = processors;
        return this;
    }

    @Override
    public Flow.Builder processors(Processor ... processors) {
        this.checkImmutable();
        this.processors = Arrays.asList(processors);
        return this;
    }

    @Override
    public Flow.Builder messagingExceptionHandler(FlowExceptionHandler exceptionListener) {
        this.checkImmutable();
        this.exceptionListener = exceptionListener;
        return this;
    }

    @Override
    public Flow.Builder processingStrategyFactory(ProcessingStrategyFactory processingStrategyFactory) {
        this.checkImmutable();
        Preconditions.checkArgument((processingStrategyFactory != null ? 1 : 0) != 0, (String)"processingStrategyFactory cannot be null");
        this.processingStrategyFactory = processingStrategyFactory;
        return this;
    }

    @Override
    public Flow.Builder withDirectProcessingStrategyFactory() {
        return this.processingStrategyFactory(new DirectProcessingStrategyFactory());
    }

    @Override
    public Flow.Builder initialState(String initialState) {
        this.checkImmutable();
        Preconditions.checkArgument((initialState != null ? 1 : 0) != 0, (String)"initialState cannot be null");
        this.initialState = initialState;
        return this;
    }

    @Override
    public Flow.Builder maxConcurrency(int maxConcurrency) {
        this.checkImmutable();
        Preconditions.checkArgument((maxConcurrency > 0 ? 1 : 0) != 0, (String)"maxConcurrency cannot be less than 1");
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    @Override
    public Flow build() {
        this.checkImmutable();
        AllStatistics statistics = this.muleContext.getStatistics();
        this.flow = new DefaultFlow(this.name, this.muleContext, this.source, this.processors, Optional.ofNullable(this.exceptionListener), Optional.ofNullable(this.processingStrategyFactory), this.initialState, this.maxConcurrency, (DefaultFlowsSummaryStatistics)statistics.getFlowSummaryStatistics(), (DefaultFlowsSummaryStatistics)statistics.getFlowSummaryStatisticsV2(), AbstractFlowConstruct.createFlowStatistics(this.name, statistics), this.componentInitialStateManager);
        return this.flow;
    }

    protected final void checkImmutable() {
        if (this.flow != null) {
            throw new IllegalStateException("Cannot change attributes once the flow was built");
        }
    }

    public static class DefaultFlow
    extends AbstractPipeline
    implements Flow {
        protected DefaultFlow(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, Integer maxConcurrency, DefaultFlowsSummaryStatistics flowsSummaryStatistics, DefaultFlowsSummaryStatistics flowsSummaryStatisticsV2, FlowConstructStatistics flowConstructStatistics, ComponentInitialStateManager componentInitialStateManager) {
            super(name, muleContext, source, processors, exceptionListener, processingStrategyFactory, initialState, maxConcurrency, flowsSummaryStatistics, flowsSummaryStatisticsV2, flowConstructStatistics, componentInitialStateManager);
            FlowExceptionHandler flowExceptionHandler = this.getExceptionListener();
            if (flowExceptionHandler instanceof GlobalErrorHandler) {
                GlobalErrorHandler globalErrorHandler = (GlobalErrorHandler)flowExceptionHandler;
                globalErrorHandler.addComponentReference(this.getName());
            }
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public ReactiveProcessor referenced() {
            return pub -> Flux.from((Publisher)pub).doOnNext(this::checkBackpressureReferenced).transform((Function)this.dispatchToFlow());
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).doOnNext(this.assertStarted()).transformDeferred(this.routeThroughProcessingStrategyTransformer()).onErrorStop();
        }

        @Override
        protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
            return MessageProcessors.createDefaultProcessingStrategyFactory();
        }

        @Override
        public boolean isSynchronous() {
            return this.getProcessingStrategy() != null ? this.getProcessingStrategy().isSynchronous() : true;
        }
    }
}

