/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.config;

import com.google.common.base.Throwables;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.tooling.api.artifact.DeclarationSession;
import org.mule.runtime.module.tooling.internal.AbstractArtifactAgnosticService;
import org.mule.runtime.module.tooling.internal.ApplicationSupplier;
import org.mule.runtime.module.tooling.internal.config.InternalDeclarationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeclarationSession
extends AbstractArtifactAgnosticService
implements DeclarationSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeclarationSession.class);
    private LazyValue<DeclarationSession> internalDeclarationSession = new LazyValue(() -> {
        try {
            return this.createInternalService(this.getStartedApplication());
        }
        catch (AbstractArtifactAgnosticService.ApplicationStartingException e) {
            Exception causeException = e.getCauseException();
            LOGGER.error("There was an error while starting temporary application for declaration session: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)causeException));
            Throwables.propagateIfPossible((Throwable)causeException, MuleRuntimeException.class);
            throw new MuleRuntimeException((Throwable)causeException);
        }
    });

    DefaultDeclarationSession(ApplicationSupplier applicationSupplier) {
        super(applicationSupplier);
    }

    private DeclarationSession createInternalService(Application application) {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating declaration session to delegate calls");
        }
        InternalDeclarationSession internalDeclarationService = new InternalDeclarationSession(((ApplicationDescriptor)application.getDescriptor()).getArtifactDeclaration());
        MuleContext muleContext = application.getArtifactContext().getMuleContext();
        if (muleContext == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find injector to create InternalDeclarationSession"));
        }
        try {
            InternalDeclarationSession internalDeclarationSession = (InternalDeclarationSession)muleContext.getInjector().inject((Object)internalDeclarationService);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creation of declaration session to delegate calls took [{}ms]", (Object)(System.currentTimeMillis() - startTime));
            }
            return internalDeclarationSession;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not inject values into DeclarationSession"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withInternalDeclarationSession(String functionName, Function<DeclarationSession, T> function) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling function: '{}'", (Object)functionName);
        }
        DeclarationSession declarationSession = this.getInternalDeclarationSession();
        long initialTime = System.currentTimeMillis();
        try {
            T t = function.apply(declarationSession);
            return t;
        }
        finally {
            long totalTimeSpent = System.currentTimeMillis() - initialTime;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Function: '{}' completed in [{}ms]", (Object)functionName, (Object)totalTimeSpent);
            }
        }
    }

    private DeclarationSession getInternalDeclarationSession() {
        return (DeclarationSession)this.internalDeclarationSession.get();
    }

    @Override
    public ConnectionValidationResult testConnection(String configName) {
        try {
            return this.withInternalDeclarationSession("testConnection()", session -> session.testConnection(configName));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while performing test connection on config: '%s'", configName), t);
            throw t;
        }
    }

    @Override
    public ValueResult getValues(ParameterizedElementDeclaration component, String providerName) {
        try {
            return this.withInternalDeclarationSession("getValues()", session -> session.getValues(component, providerName));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while resolving values on component: '%s:%s' for providerName: '%s'", component.getDeclaringExtension(), component.getName(), providerName), t);
            throw t;
        }
    }

    @Override
    public ValueResult getFieldValues(ParameterizedElementDeclaration component, String providerName, String targetSelector) {
        try {
            return this.withInternalDeclarationSession("getFieldValues()", session -> session.getFieldValues(component, providerName, targetSelector));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while resolving field values on component: '%s:%s' for providerName: '%s' with targetSelector: '%s'", component.getDeclaringExtension(), component.getName(), providerName, targetSelector), t);
            throw t;
        }
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentElementDeclaration component) {
        try {
            return this.withInternalDeclarationSession("getMetadataKeys()", session -> session.getMetadataKeys(component));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while resolving metadata keys on component: '%s:%s'", component.getDeclaringExtension(), component.getName()), t);
            throw t;
        }
    }

    @Override
    public MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentMetadata(ComponentElementDeclaration component) {
        try {
            return this.withInternalDeclarationSession("resolveComponentMetadata()", session -> session.resolveComponentMetadata(component));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while resolving metadata on component: '%s:%s'", component.getDeclaringExtension(), component.getName()), t);
            throw t;
        }
    }

    @Override
    public void disposeMetadataCache(ComponentElementDeclaration component) {
        try {
            this.withInternalDeclarationSession("disposeMetadataCache()", session -> {
                session.disposeMetadataCache(component);
                return null;
            });
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while disposing metadata on component: '%s:%s'", component.getDeclaringExtension(), component.getName()), t);
            throw t;
        }
    }

    @Override
    public SampleDataResult getSampleData(ComponentElementDeclaration component) {
        try {
            return this.withInternalDeclarationSession("getSampleData()", session -> session.getSampleData(component));
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Error while retrieving sample data on component: '%s:%s'", component.getDeclaringExtension(), component.getName()), t);
            throw t;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

