/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.ApiKitStatsUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.construct.BackPressureStrategySelector;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.execution.FlowProcessor;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.interception.ReactiveInterceptor;
import org.mule.runtime.core.internal.management.stats.DefaultFlowsSummaryStatistics;
import org.mule.runtime.core.internal.management.stats.FlowClassifier;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.processor.interceptor.FlowInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    private static final int DISPATCH_WARN_AFTER_SOURCE_STOP_THRESHOLD_MILLIS = 1000;
    private final InterceptorManager interceptorManager;
    private final NotificationDispatcher notificationFirer;
    private final SchedulerService schedulerService;
    private final MessageSource source;
    private final List<Processor> processors;
    private MessageProcessorChain pipeline;
    private Consumer<Exception> errorRouterForSourceResponseError;
    private final ProcessingStrategyFactory processingStrategyFactory;
    private final ProcessingStrategy processingStrategy;
    private final List<ReactiveInterceptor> flowInterceptors = new LinkedList<ReactiveInterceptor>();
    private volatile long stopTimestamp = Long.MAX_VALUE;
    private volatile boolean canProcessMessage = false;
    private Sink sink;
    private Scheduler completionCallbackScheduler;
    private Map<BackPressureReason, FlowBackPressureException> backPressureExceptions;
    private final int maxConcurrency;
    private final DefaultFlowsSummaryStatistics flowsSummaryStatistics;
    private final DefaultFlowsSummaryStatistics flowsSummaryStatisticsV2;
    private final boolean triggerFlow;
    private final boolean apikitFlow;
    private final FlowClassifier.FlowType flowType;
    private final ComponentInitialStateManager componentInitialStateManager;
    private final BackPressureStrategySelector backpressureStrategySelector;
    private final ErrorType FLOW_BACKPRESSURE_ERROR_TYPE;
    private AlertingSupport alertingSupport;
    private ComponentTracerFactory componentTracerFactory;

    public AbstractPipeline(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, Integer maxConcurrency, DefaultFlowsSummaryStatistics flowsSummaryStatistics, DefaultFlowsSummaryStatistics flowsSummaryStatisticsV2, FlowConstructStatistics flowConstructStatistics, ComponentInitialStateManager componentInitialStateManager) {
        super(name, muleContext, exceptionListener, initialState, flowConstructStatistics);
        FlowClassifier flowClassifier;
        try {
            this.interceptorManager = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(InterceptorManager.class);
            this.notificationFirer = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
            this.componentTracerFactory = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(ComponentTracerFactory.class);
            this.alertingSupport = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(AlertingSupport.class);
            flowClassifier = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(FlowClassifier.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        this.schedulerService = muleContext.getSchedulerService();
        this.source = source;
        this.componentInitialStateManager = componentInitialStateManager;
        this.processors = Collections.unmodifiableList(processors);
        this.maxConcurrency = maxConcurrency != null ? maxConcurrency : AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY;
        this.flowsSummaryStatistics = flowsSummaryStatistics;
        this.flowsSummaryStatisticsV2 = flowsSummaryStatisticsV2;
        this.triggerFlow = source != null;
        this.apikitFlow = ApiKitStatsUtils.isApiKitFlow(this.getName());
        this.flowType = flowClassifier != null ? flowClassifier.getFlowType(this.getName()) : FlowClassifier.FlowType.GENERIC;
        ProcessingStrategyFactory processingStrategyFactory2 = this.processingStrategyFactory = processingStrategyFactory.orElseGet(this::defaultProcessingStrategy);
        if (processingStrategyFactory2 instanceof AsyncProcessingStrategyFactory) {
            AsyncProcessingStrategyFactory asyncProcessingStrategyFactory = (AsyncProcessingStrategyFactory)processingStrategyFactory2;
            asyncProcessingStrategyFactory.setMaxConcurrency(this.maxConcurrency);
        } else if (maxConcurrency != null) {
            LOGGER.warn("{} does not support 'maxConcurrency'. Ignoring the value.", (Object)this.processingStrategyFactory.getClass().getSimpleName());
        }
        this.processingStrategy = this.processingStrategyFactory.create(muleContext, this.getName());
        this.backpressureStrategySelector = new BackPressureStrategySelector(this);
        this.FLOW_BACKPRESSURE_ERROR_TYPE = (ErrorType)muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).orElseThrow();
    }

    protected MessageProcessorChain createPipeline() {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("flow @ " + this.getName());
        builder.setProcessingStrategy(Objects.requireNonNull(this.processingStrategy));
        this.configureMessageProcessors(builder);
        builder.setMessagingExceptionHandler(this.getExceptionListener());
        builder.setPipelineLocation(this.getLocation());
        builder.setComponentTracer((ComponentTracer<CoreEvent>)this.componentTracerFactory.fromComponent((Component)this));
        return builder.build();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        return MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext, this::createDefaultProcessingStrategyFactory);
    }

    @Override
    public List<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public MessageSource getSource() {
        return this.source;
    }

    @Override
    public boolean isSynchronous() {
        return this.processingStrategy.isSynchronous();
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        this.backPressureExceptions = Collections.unmodifiableMap(Arrays.stream(BackPressureReason.values()).collect(Collectors.toMap(Function.identity(), backPressureReason -> FlowBackPressureException.createFlowBackPressureException(this, backPressureReason))));
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.source != null) {
            this.source.setListener(new Processor(){

                @Override
                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply(event, this);
                }

                @Override
                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Flux.from(publisher).transform((Function)AbstractPipeline.this.dispatchToFlow());
                }
            });
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.source, this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.pipeline, this.muleContext);
        this.completionCallbackScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(this.getName() + ".flux.completionCallback"));
        this.flowInterceptors.addAll(ReactiveInterceptorAdapter.createInterceptors(this.interceptorManager.getFlowInterceptorFactories().stream().map(FlowInterceptorFactoryAdapter::new).toList(), this.muleContext.getInjector()));
        this.doInitialiseProcessingStrategy();
        this.updateFlowsSummaryStatistics(t -> t.incrementDeclaredTriggerFlow(this.getName()), t -> t.incrementDeclaredApikitFlow(this.getName()), t -> t.incrementDeclaredPrivateFlow(this.getName()));
    }

    @Override
    protected void doInitialiseProcessingStrategy() throws MuleException {
        LOGGER.debug("Initialising processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        super.doInitialiseProcessingStrategy();
        LifecycleUtils.initialiseIfNeeded((Object)this.processingStrategy, this.muleContext);
    }

    public Consumer<Exception> errorRouterForSourceResponseError(Function<Pipeline, Consumer<Exception>> terminationCallbackFactory) {
        if (this.errorRouterForSourceResponseError == null) {
            return this.doErrorRouterForSourceResponseError(terminationCallbackFactory);
        }
        return this.errorRouterForSourceResponseError;
    }

    private synchronized Consumer<Exception> doErrorRouterForSourceResponseError(Function<Pipeline, Consumer<Exception>> terminationCallbackFactory) {
        if (this.errorRouterForSourceResponseError == null) {
            Consumer<Exception> terminationCallback = terminationCallbackFactory.apply(this);
            this.errorRouterForSourceResponseError = this.getExceptionListener().router(Function.identity(), event -> terminationCallback.accept((Exception)((Object)((MessagingException)((Object)((Object)((Error)event.getError().get()).getCause()))))), error -> terminationCallback.accept((Exception)((Object)((MessagingException)((Object)((Object)error))))));
        }
        return this.errorRouterForSourceResponseError;
    }

    protected final ReactiveProcessor dispatchToFlow() {
        return publisher -> Flux.from((Publisher)publisher).doOnNext(this.assertStarted()).transform(this.routeThroughProcessingStrategyTransformer()).transformDeferred(this.clearSubscribersErrorStrategy());
    }

    private Function<Flux<CoreEvent>, Publisher<CoreEvent>> clearSubscribersErrorStrategy() {
        return pub -> pub.contextWrite(context -> {
            Optional onErrorStrategy = context.getOrEmpty((Object)"reactor.onNextError.localStrategy");
            if (onErrorStrategy.isPresent() && onErrorStrategy.get().toString().contains("reactor.core.publisher.OnNextFailureStrategy$ResumeStrategy")) {
                BiFunction<Throwable, Object, Throwable> onErrorContinue = (e, o) -> null;
                return context.put((Object)"reactor.onNextError.localStrategy", onErrorContinue);
            }
            return context;
        });
    }

    protected Function<Publisher<CoreEvent>, Publisher<CoreEvent>> routeThroughProcessingStrategyTransformer() {
        FluxSinkRecorder pipelineOutlet = new FluxSinkRecorder();
        return eventPublisher -> Flux.from((Publisher)eventPublisher).transformDeferredContextual((pipelineUpstream, reactorContext) -> {
            if (((Boolean)reactorContext.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
                return this.handlePipelineError((Flux<Either<Throwable, CoreEvent>>)Flux.from(RxUtils.propagateCompletion(pipelineUpstream, pipelineOutlet.flux(), pipelineInlet -> this.splicePipeline(pipelineOutlet, (Publisher<CoreEvent>)pipelineInlet, true), pipelineOutlet::complete, pipelineOutlet::error)));
            }
            return this.handlePipelineError((Flux<Either<Throwable, CoreEvent>>)Flux.from(RxUtils.propagateCompletion(pipelineUpstream, pipelineOutlet.flux(), pipelineInlet -> this.splicePipeline(pipelineOutlet, (Publisher<CoreEvent>)pipelineInlet, false), pipelineOutlet::complete, pipelineOutlet::error, this.muleContext.getConfiguration().getShutdownTimeout(), (ScheduledExecutorService)this.completionCallbackScheduler, this.getDslSource())));
        });
    }

    private Flux<Either<Throwable, CoreEvent>> splicePipeline(FluxSinkRecorder<Either<Throwable, CoreEvent>> sinkRecorder, Publisher<CoreEvent> innerEventPub, boolean isWithinProcessToApply) {
        return Flux.from(innerEventPub).doOnNext(event -> ((BaseEventContext)event.getContext()).onResponse((e, t) -> {
            if (t != null) {
                sinkRecorder.next(Either.left((Object)t, CoreEvent.class));
            } else if (e != null) {
                sinkRecorder.next(Either.right(Throwable.class, (Object)e));
            }
            if (isWithinProcessToApply) {
                sinkRecorder.complete();
            }
        })).doOnNext(this.getSource() == null || this.getSource().getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT ? event -> this.sink.accept((CoreEvent)event) : this::sinkEmit).map(e -> Either.empty());
    }

    private Flux<CoreEvent> handlePipelineError(Flux<Either<Throwable, CoreEvent>> flux) {
        return flux.map(result -> {
            result.applyLeft(t -> {
                throw Exceptions.propagate((Throwable)t);
            });
            return (CoreEvent)result.getRight();
        });
    }

    private void sinkEmit(CoreEvent event) {
        BackPressureReason emitFailReason = this.sink.emit(event);
        if (emitFailReason != null) {
            this.alertingSupport.triggerAlert("BACKPRESSURE_TRIGGERED", (Object)(emitFailReason.name() + " - " + this.getName()));
            this.notifyBackpressureException(event, this.backPressureExceptions.get((Object)emitFailReason));
        }
    }

    private void notifyBackpressureException(CoreEvent event, FlowBackPressureException wrappedException) {
        CoreEvent errorEvent = CoreEvent.builder(event).error(ErrorBuilder.builder((Throwable)((Object)wrappedException)).errorType(this.FLOW_BACKPRESSURE_ERROR_TYPE).build()).build();
        ((BaseEventContext)event.getContext()).error((Throwable)((Object)new MessagingException(errorEvent, (Throwable)((Object)wrappedException), (Component)this)));
    }

    private ReactiveProcessor processFlowFunction() {
        ReactiveProcessor interceptedPipeline;
        if (this.flowInterceptors.isEmpty()) {
            interceptedPipeline = this.pipeline;
        } else {
            FlowProcessor flowProcessor;
            ReactiveProcessor interceptorWrapperProcessorFunction = flowProcessor = new FlowProcessor(this.pipeline, this);
            for (ReactiveInterceptor interceptor : this.flowInterceptors) {
                interceptorWrapperProcessorFunction = (ReactiveProcessor)interceptor.apply(flowProcessor, interceptorWrapperProcessorFunction);
            }
            interceptedPipeline = interceptorWrapperProcessorFunction;
        }
        return stream -> Flux.from((Publisher)stream).doOnNext(this.beforeProcessors()).transform((Function)this.processingStrategy.onPipeline(interceptedPipeline)).doOnNext(this.afterProcessors()).onErrorContinue(MessagingException.class, (me, e) -> ((BaseEventContext)((MessagingException)((Object)((Object)((Object)me)))).getEvent().getContext()).error((Throwable)me));
    }

    private Consumer<CoreEvent> beforeProcessors() {
        return event -> {
            this.getStatistics().incReceivedEvents();
            FlowCallStack flowCallStack = event.getFlowCallStack();
            if (flowCallStack instanceof DefaultFlowCallStack) {
                DefaultFlowCallStack fs = (DefaultFlowCallStack)flowCallStack;
                fs.push(new FlowStackElement(this.getName(), this.getIdentifier(), null, this.getLocation(), this.getAnnotations()));
            }
            this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)this), this.getName(), 1801));
            long startTime = System.currentTimeMillis();
            BaseEventContext baseEventContext = (BaseEventContext)event.getContext();
            baseEventContext.onComplete((response, throwable) -> {
                MessagingException messagingException = null;
                if (throwable != null) {
                    MessagingException msgException;
                    messagingException = throwable instanceof MessagingException ? (msgException = (MessagingException)((Object)((Object)((Object)throwable)))) : new MessagingException((CoreEvent)event, (Throwable)throwable, (Component)this);
                    response = messagingException.getEvent();
                }
                this.fireCompleteNotification((CoreEvent)response, messagingException);
                baseEventContext.getProcessingTime().ifPresent(time -> time.addFlowExecutionBranchTime(startTime));
            });
        };
    }

    private void fireCompleteNotification(CoreEvent event, MessagingException messagingException) {
        if (event != null) {
            FlowCallStack flowCallStack = event.getFlowCallStack();
            if (flowCallStack instanceof DefaultFlowCallStack) {
                DefaultFlowCallStack fs = (DefaultFlowCallStack)flowCallStack;
                fs.pop();
            }
        } else {
            LOGGER.warn("No event on flow completion", (Throwable)((Object)messagingException));
        }
        this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)messagingException), (Component)this), this.getName(), 1804));
    }

    private Consumer<CoreEvent> afterProcessors() {
        return response -> {
            this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)response, null, (Component)this), this.getName(), 1802));
            ((BaseEventContext)response.getContext()).success((CoreEvent)response);
        };
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) {
        builder.chain((Processor[])this.getProcessors().toArray(Processor[]::new));
    }

    @Override
    protected void doStartProcessingStrategy() throws MuleException {
        LOGGER.debug("Starting processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        super.doStartProcessingStrategy();
        this.startIfStartable(this.processingStrategy);
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        try {
            LOGGER.debug("Starting pipeline of flow '{}'...", (Object)this.getName());
            this.startIfStartable(this.pipeline);
            this.sink = this.processingStrategy.createSink(this, this.processFlowFunction());
        }
        catch (Exception e) {
            this.stopOnFailure(e);
            return;
        }
        this.canProcessMessage = true;
        if (this.source != null && this.getMuleContext().isStarted()) {
            try {
                if (this.componentInitialStateManager.mustStartMessageSource((Component)this.source)) {
                    LOGGER.debug("Starting source '{}' of flow '{}'...", (Object)this.source.getIdentifier(), (Object)this.getName());
                    this.startIfStartable(this.source);
                } else {
                    LOGGER.info("Not starting source '{}' for '{}' because of {}", new Object[]{this.source.getIdentifier(), this.getName(), this.componentInitialStateManager});
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (Exception e) {
                this.stopOnFailure(e);
            }
        }
        this.updateFlowsSummaryStatistics(DefaultFlowsSummaryStatistics::incrementActiveTriggerFlow, DefaultFlowsSummaryStatistics::incrementActiveApikitFlow, DefaultFlowsSummaryStatistics::incrementActivePrivateFlow);
    }

    private void stopOnFailure(Exception e) throws MuleException {
        this.stopSafely(this::doStop);
        this.stopSafely(this::doStopProcessingStrategy);
        if (e instanceof MuleException) {
            MuleException muleException = (MuleException)((Object)e);
            throw muleException;
        }
        throw new DefaultMuleException((Throwable)e);
    }

    private void stopSafely(CheckedRunnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw e;
            }
            LOGGER.atWarn().setCause((Throwable)e).log("Stopping pipeline '{}', but an exception was thrown while shutting down: {}", (Object)this.getName(), (Object)e.getMessage());
        }
    }

    public Consumer<CoreEvent> assertStarted() {
        return event -> {
            if (!this.canProcessMessage) {
                if (this.source != null) {
                    this.getAlertingSupport().triggerAlert("EVENT_DISPATCHED_AFTER_STOP", Arrays.asList(this.source.getIdentifier().toString(), this.getName()));
                    LOGGER.warn("Source '{}' in flow '{}' dispatched an event after being stopped", (Object)this.source.getIdentifier(), (Object)this.getName());
                }
                MessagingException exception = new MessagingException((CoreEvent)event, (Throwable)new LifecycleException(CoreMessages.isStopped(this.getName()), (Object)this));
                ((BaseEventContext)event.getContext()).error((Throwable)((Object)exception));
                throw Exceptions.propagate((Throwable)((Object)exception));
            }
            if (this.source != null && this.stopTimestamp + 1000L < System.currentTimeMillis()) {
                this.getAlertingSupport().triggerAlert("EVENT_DISPATCHED_AFTER_STOP", Arrays.asList(this.source.getIdentifier().toString(), this.getName()));
                LOGGER.warn("Source '{}' in flow '{}' dispatched an event after being requested to stop", (Object)this.source.getIdentifier(), (Object)this.getName());
            }
        };
    }

    @Override
    protected void doStop() throws MuleException {
        this.updateFlowsSummaryStatistics(DefaultFlowsSummaryStatistics::decrementActiveTriggerFlow, DefaultFlowsSummaryStatistics::decrementActiveApikitFlow, DefaultFlowsSummaryStatistics::decrementActivePrivateFlow);
        if (this.source != null) {
            this.stopSafely(() -> {
                this.stopTimestamp = System.currentTimeMillis();
                if (this.componentInitialStateManager.mustStartMessageSource((Component)this.source)) {
                    LOGGER.debug("Stopping source '{}' of flow '{}'...", (Object)this.source.getIdentifier(), (Object)this.getName());
                    this.stopIfStoppable(this.source);
                } else {
                    LOGGER.info("Not stopping source '{}' for '{}', it was not started because of {}", new Object[]{this.source.getIdentifier(), this.getName(), this.componentInitialStateManager});
                }
            });
        }
        this.canProcessMessage = false;
        LOGGER.debug("Stopping pipeline of flow '{}'...", (Object)this.getName());
        this.stopSafely(() -> this.disposeIfDisposable(this.sink));
        this.sink = null;
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doStopProcessingStrategy() throws MuleException {
        LOGGER.debug("Stopping processing strategy ({}) of flow '{}'...", (Object)this.processingStrategy, (Object)this.getName());
        this.stopIfStoppable(this.processingStrategy);
        super.doStopProcessingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDispose() {
        this.updateFlowsSummaryStatistics(t -> t.decrementDeclaredTriggerFlow(this.getName()), t -> t.decrementDeclaredApikitFlow(this.getName()), t -> t.decrementDeclaredPrivateFlow(this.getName()));
        if (this.errorRouterForSourceResponseError != null) {
            AbstractPipeline abstractPipeline = this;
            synchronized (abstractPipeline) {
                if (this.errorRouterForSourceResponseError != null) {
                    this.disposeIfDisposable(this.errorRouterForSourceResponseError);
                }
            }
        }
        if (this.completionCallbackScheduler != null) {
            this.completionCallbackScheduler.stop();
        }
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.source);
        this.disposeIfDisposable(this.processingStrategy);
        super.doDispose();
    }

    private void updateFlowsSummaryStatistics(Consumer<DefaultFlowsSummaryStatistics> triggerFlowsUpdater, Consumer<DefaultFlowsSummaryStatistics> apikitflowsUpdater, Consumer<DefaultFlowsSummaryStatistics> privateFlowsUpdater) {
        if (this.triggerFlow) {
            triggerFlowsUpdater.accept(this.flowsSummaryStatistics);
        } else if (this.apikitFlow) {
            apikitflowsUpdater.accept(this.flowsSummaryStatistics);
        } else {
            privateFlowsUpdater.accept(this.flowsSummaryStatistics);
        }
        if (this.triggerFlow) {
            triggerFlowsUpdater.accept(this.flowsSummaryStatisticsV2);
        } else {
            switch (this.flowType) {
                case APIKIT: 
                case SOAPKIT: {
                    apikitflowsUpdater.accept(this.flowsSummaryStatisticsV2);
                    break;
                }
                case GENERIC: {
                    privateFlowsUpdater.accept(this.flowsSummaryStatisticsV2);
                }
            }
        }
    }

    protected Sink getSink() {
        return this.sink;
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public ProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    public AlertingSupport getAlertingSupport() {
        return this.alertingSupport;
    }

    @Override
    public void checkBackpressure(CoreEvent event) throws RuntimeException {
        try {
            this.backpressureStrategySelector.check(event);
        }
        catch (FlowBackPressureException e) {
            throw Exceptions.propagate((Throwable)((Object)e));
        }
    }

    protected void checkBackpressureReferenced(CoreEvent event) throws RuntimeException {
        try {
            this.backpressureStrategySelector.checkWithWaitStrategy(event);
        }
        catch (FlowBackPressureException e) {
            throw Exceptions.propagate((Throwable)((Object)e));
        }
    }

    public Map<BackPressureReason, FlowBackPressureException> getBackPressureExceptions() {
        return this.backPressureExceptions;
    }
}

