/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.SimpleLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConstructLifecycleManager
extends SimpleLifecycleManager<FlowConstruct> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowConstructLifecycleManager.class);
    private final NotificationDispatcher notificationFirer;

    public FlowConstructLifecycleManager(FlowConstruct flowConstruct, NotificationDispatcher notificationFirer) {
        super(flowConstruct.getName(), flowConstruct);
        this.notificationFirer = notificationFirer;
    }

    @Override
    public synchronized void fireInitialisePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("initialise");
        LOGGER.info("Initialising flow: {}", (Object)((FlowConstruct)this.getLifecycleObject()).getName());
        this.invokePhase("initialise", this.getLifecycleObject(), callback);
        this.fireNotification(1501);
    }

    @Override
    public synchronized void fireStartPhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("start");
        LOGGER.info("Starting flow: {}", (Object)((FlowConstruct)this.getLifecycleObject()).getName());
        this.invokePhase("start", this.getLifecycleObject(), callback);
        this.fireNotification(1502);
    }

    @Override
    public synchronized void fireStopPhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("stop");
        LOGGER.info("Stopping flow: {}", (Object)((FlowConstruct)this.getLifecycleObject()).getName());
        this.invokePhase("stop", this.getLifecycleObject(), callback);
        this.fireNotification(1503);
    }

    @Override
    public synchronized void fireDisposePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("dispose");
        LOGGER.info("Disposing flow: {}", (Object)((FlowConstruct)this.getLifecycleObject()).getName());
        this.invokePhase("dispose", this.getLifecycleObject(), callback);
        this.fireNotification(1506);
    }

    protected void fireNotification(int action) {
        this.notificationFirer.dispatch((Notification)new FlowConstructNotification(((FlowConstruct)this.getLifecycleObject()).getName(), action));
    }
}

