/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.ResourceLocator;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.internal.context.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.ConnectionsDataExtractor;
import org.mule.runtime.config.internal.context.FlowClassifierFactory;
import org.mule.runtime.config.internal.context.NoOpLazyComponentInitializer;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.config.internal.factories.ExtensionManagerFactoryBean;
import org.mule.runtime.config.internal.factories.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.factories.MuleContextFactoryBean;
import org.mule.runtime.config.internal.factories.TransactionManagerFactoryBean;
import org.mule.runtime.config.internal.model.dsl.config.DefaultComponentInitialStateManager;
import org.mule.runtime.config.internal.registry.SpringRegistryBootstrap;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.DefaultFeatureManagementService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.connection.DefaultConnectivityTesterFactory;
import org.mule.runtime.core.internal.connection.DelegateConnectionManagerAdapter;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.internal.el.function.MuleFunctionsBindingContextProvider;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.exception.MessagingExceptionLocationProvider;
import org.mule.runtime.core.internal.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.transformer.ExtendedTransformationService;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.queue.wrapper.LocalQueueManagerWrapper;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueManagerWrapper;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.http.support.api.HttpServiceApiDelegate;
import org.mule.runtime.module.extension.api.runtime.compatibility.DefaultForwardCompatibilityHelper;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreManagerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class SpringMuleContextServiceConfigurator
extends AbstractSpringMuleContextServiceConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMuleContextServiceConfigurator.class);
    private static final ImmutableMap<String, String> OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME = ImmutableMap.builder().put((Object)"_defaultInMemoryObjectStore", (Object)"_localInMemoryObjectStore").put((Object)"_defaultPersistentObjectStore", (Object)"_localPersistentObjectStore").build();
    private final MuleContextWithRegistry muleContext;
    private final ArtifactType artifactType;
    private final ArtifactAst artifactAst;
    private final ResourceLocator resourceLocator;
    private final ImmutableMap<String, BeanDefinition> defaultContextServices = ImmutableMap.builder().put((Object)"_muleTransactionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionManagerFactoryBean.class)).put((Object)"_muleExtensionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtensionManagerFactoryBean.class)).put((Object)"_muleConnectionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DelegateConnectionManagerAdapter.class)).put((Object)"_muleConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleConfigurationConfigurator.class)).put((Object)"_muleTransactionFactoryLocator", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionFactoryLocator.class)).put((Object)"_mulePolicyManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyManager.class)).put((Object)"_muleInterceptorManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessorInterceptorManager.class)).put((Object)"_muleNotificationDispatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationDispatcher.class)).put((Object)"_muleNotificationListenerRegistry", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationListenerRegistry.class)).put((Object)"_muleEventContextService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultEventContextService.class)).put((Object)"_defaultInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localInMemoryObjectStore").getBeanDefinition()).put((Object)"_localInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultInMemoryObjectStore")).put((Object)"_defaultPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localPersistentObjectStore").getBeanDefinition()).put((Object)"_localPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultPersistentObjectStore")).put((Object)"_muleObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getPrimaryBeanDefinition(MuleObjectStoreManager.class)).put((Object)"_sdkObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getPrimaryBeanDefinition(SdkObjectStoreManagerAdapter.class)).put((Object)"_muleApiQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionalQueueManager.class)).put((Object)"_muleQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(QueueManagerWrapper.class)).put((Object)"_muleSecurityManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMuleSecurityManager.class)).put((Object)"_muleMessageProcessingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMessageProcessingManager.class)).put((Object)"_muleStreamCloserService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamCloserService.class)).put((Object)"_converterResolver", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DynamicDataTypeConversionResolver.class)).put((Object)"_muleLockFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleLockFactory.class, true)).put((Object)"_muleLockProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SingleServerLockProvider.class)).put((Object)"_muleProcessingTimeWatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessingTimeWatcher.class)).put((Object)"_muleExceptionLocationProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessagingExceptionLocationProvider.class)).put((Object)"_muleMessageProcessingFlowTraceManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessageProcessingFlowTraceManager.class)).put((Object)"_muleComponentInitialStateManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultComponentInitialStateManager.class)).put((Object)"_muleTransformationService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtendedTransformationService.class)).put((Object)"_muleClusterService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultClusterService.class)).put((Object)"_muleConnectivityTesterFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectivityTesterFactory.class)).put((Object)"_muleLazyComponentInitializer", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(NoOpLazyComponentInitializer.class)).put((Object)"PROFILING_FEATURE_MANAGEMENT_SERVICE", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultFeatureManagementService.class)).put((Object)"_muleForwardCompatibilityHelper", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultForwardCompatibilityHelper.class)).put((Object)"_httpServiceApi", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(HttpServiceApiDelegate.class)).build();
    private final MuleFunctionsBindingContextProvider coreFunctionsProvider;
    private final ConfigurationProperties configurationProperties;
    private final Map<String, String> artifactProperties;

    public SpringMuleContextServiceConfigurator(MuleContextWithRegistry muleContext, MuleFunctionsBindingContextProvider coreFunctionsProvider, ConfigurationProperties configurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, ArtifactAst artifactAst, BeanDefinitionRegistry beanDefinitionRegistry, ResourceLocator resourceLocator) {
        super((InternalCustomizationService)muleContext.getCustomizationService(), beanDefinitionRegistry);
        this.muleContext = muleContext;
        this.coreFunctionsProvider = coreFunctionsProvider;
        this.configurationProperties = configurationProperties;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.artifactAst = artifactAst;
        this.resourceLocator = resourceLocator;
    }

    protected void createArtifactServices() {
        new ConnectionsDataExtractor(this.artifactAst).persist();
        this.registerBeanDefinition("_muleContext", this.createMuleContextDefinition());
        this.registerConstantBeanDefinition("_muleConfigurationAttributesResolver", this.configurationProperties);
        this.registerConstantBeanDefinition("_muleNotificationHandler", this.muleContext.getNotificationManager());
        this.registerConstantBeanDefinition("_muleFlowClassifier", new FlowClassifierFactory(this.artifactAst).create());
        this.registerConstantBeanDefinition("_muleStatistics", this.muleContext.getStatistics());
        this.registerConstantBeanDefinition("_muleResourceLocator", this.resourceLocator);
        if (!this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            this.loadServiceConfigurators();
        }
        this.registerContextServices((Map<String, BeanDefinition>)this.defaultContextServices, this.artifactType.equals((Object)ArtifactType.DOMAIN));
        this.createBootstrapBeanDefinitions();
        this.createLocalObjectStoreBeanDefinitions();
        this.createLocalLockFactoryBeanDefinitions();
        this.createQueueManagerBeanDefinitions();
        this.createCustomServices();
        this.coreFunctionsProvider.setConfigurationProperties(this.configurationProperties);
        this.registerConstantBeanDefinition("core.global.binding.provider", this.coreFunctionsProvider);
        this.getArtifactProperties().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("mule.application.deployment")).forEach(e -> this.registerConstantBeanDefinition((String)e.getKey(), e.getValue()));
        if (Boolean.parseBoolean(this.getArtifactProperties().get("mule.application.deployment.addArtifactAstToRegistry"))) {
            this.registerConstantBeanDefinition("_muleArtifactAst", this.artifactAst);
        }
    }

    private void createCustomServices() {
        Map customServices = this.getCustomizationService().getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = (CustomService)customServices.get(serviceName);
            if (customService.isBaseContext() || this.isServiceRuntimeProvided(customService)) continue;
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService, serviceName);
            LOGGER.debug("Registering runtime service '{}' for {}...", (Object)serviceName, (Object)this.artifactType.name());
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void createQueueManagerBeanDefinitions() {
        AtomicBoolean customManagerDefined = new AtomicBoolean(false);
        this.getCustomizationService().getOverriddenService("_muleQueueManager").ifPresent(customService -> {
            customManagerDefined.set(true);
            this.registerBeanDefinition("_muleQueueManager", this.getCustomServiceBeanDefinition((CustomService)customService, "_muleQueueManager"));
        });
        this.getCustomizationService().getOverriddenService("_muleApiQueueManager").ifPresent(customService -> {
            customManagerDefined.set(true);
            this.registerBeanDefinition("_muleApiQueueManager", this.getCustomServiceBeanDefinition((CustomService)customService, "_muleApiQueueManager"));
        });
        if (customManagerDefined.get()) {
            this.registerBeanDefinition("_localQueueManager", SpringMuleContextServiceConfigurator.getBeanDefinition(LocalQueueManagerWrapper.class));
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleQueueManager", "_localQueueManager");
        }
    }

    private void createLocalLockFactoryBeanDefinitions() {
        AtomicBoolean customLockFactoryWasDefined = new AtomicBoolean(false);
        this.getCustomizationService().getOverriddenService("_muleLockFactory").ifPresent(customService -> {
            customLockFactoryWasDefined.set(true);
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLockFactory", this.getCustomServiceBeanDefinition((CustomService)customService, "_muleLockFactory"));
        });
        if (customLockFactoryWasDefined.get()) {
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLocalLockFactory", (BeanDefinition)this.defaultContextServices.get((Object)"_muleLockFactory"));
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleLockFactory", "_muleLocalLockFactory");
        }
    }

    private void createLocalObjectStoreBeanDefinitions() {
        AtomicBoolean anyBaseStoreWasRedefined = new AtomicBoolean(false);
        OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME.entrySet().forEach(objectStoreLocal -> this.getCustomizationService().getOverriddenService((String)objectStoreLocal.getKey()).ifPresent(customService -> {
            anyBaseStoreWasRedefined.set(true);
            this.getBeanDefinitionRegistry().registerBeanDefinition((String)objectStoreLocal.getKey(), this.getCustomServiceBeanDefinition((CustomService)customService, (String)objectStoreLocal.getKey()));
        }));
        if (anyBaseStoreWasRedefined.get()) {
            AbstractBeanDefinition beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleObjectStoreManager.class).addPropertyValue("basePersistentStoreKey", (Object)"_localPersistentObjectStore").addPropertyValue("baseTransientStoreKey", (Object)"_localInMemoryObjectStore").getBeanDefinition();
            beanDefinition.setPrimary(false);
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLocalObjectStoreManager", (BeanDefinition)beanDefinition);
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleObjectStoreManager", "_muleLocalObjectStoreManager");
        }
    }

    private BeanDefinition createMuleContextDefinition() {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleContextFactoryBean.class).addConstructorArgValue((Object)this.muleContext).getBeanDefinition();
    }

    protected void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext.getRegistryBootstrapServiceDiscoverer(), this::registerBeanDefinition, AbstractRegistryBootstrap.BINDING_PROVIDER_PREDICATE.or(AbstractRegistryBootstrap.TRANSFORMER_PREDICATE).negate());
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private static BeanDefinition getPrimaryBeanDefinition(Class<?> beanType) {
        BeanDefinition beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinition(beanType);
        beanDefinition.setPrimary(true);
        return beanDefinition;
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType, String factoryMethodName) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).setFactoryMethod(factoryMethodName).getBeanDefinition();
    }

    protected MuleContextWithRegistry getMuleContext() {
        return this.muleContext;
    }

    protected Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }
}

