/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedObjectStoreWrapper<T extends Serializable>
extends TemplateObjectStore<T>
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionedObjectStoreWrapper.class);
    private String partitionName;
    private ObjectStore<T> baseStore;

    public PartitionedObjectStoreWrapper(String name, ObjectStore<T> store) {
        this.partitionName = name;
        this.baseStore = store;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.baseStore, LOGGER);
    }

    private String partitioned(String key) {
        return this.partitionName + "|" + key;
    }

    private Pair<String, String> splitKey(String key) {
        int split = key.indexOf("|");
        if (split < 1) {
            throw new IllegalStateException("Invalid partitioned key " + key);
        }
        return new Pair((Object)key.substring(0, split), (Object)key.substring(split + 1));
    }

    protected void validateKey(String key) throws ObjectStoreException {
        super.validateKey(this.partitioned(key));
    }

    protected boolean doContains(String key) throws ObjectStoreException {
        return this.getStore().contains(this.partitioned(key));
    }

    protected void doStore(String key, T value) throws ObjectStoreException {
        this.getStore().store(this.partitioned(key), value);
    }

    protected T doRetrieve(String key) throws ObjectStoreException {
        return (T)this.getStore().retrieve(this.partitioned(key));
    }

    public void clear() throws ObjectStoreException {
        for (String key : this.allKeys()) {
            this.remove(key);
        }
    }

    protected T doRemove(String key) throws ObjectStoreException {
        return (T)this.getStore().remove(this.partitioned(key));
    }

    public boolean isPersistent() {
        return this.getStore().isPersistent();
    }

    public boolean isDistributed() {
        return this.getStore().isDistributed();
    }

    public void open() throws ObjectStoreException {
        this.getStore().open();
    }

    public void close() throws ObjectStoreException {
        this.getStore().close();
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.getStore().allKeys().stream().map(this::splitKey).filter(key -> ((String)key.getFirst()).equals(this.partitionName)).map(Pair::getSecond).collect(Collectors.toList());
    }

    public Map<String, T> retrieveAll() throws ObjectStoreException {
        Map all = this.getStore().retrieveAll();
        LinkedHashMap result = new LinkedHashMap();
        all.forEach((k, v) -> {
            Pair<String, String> key = this.splitKey((String)k);
            if (this.partitionName.equals(key.getFirst())) {
                result.put((String)key.getSecond(), v);
            }
        });
        return result;
    }

    private ObjectStore<T> getStore() {
        return this.baseStore;
    }

    public ObjectStore<T> getBaseStore() {
        return this.getStore();
    }
}

