/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import jakarta.inject.Inject;
import java.util.List;
import java.util.OptionalLong;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.config.internal.bean.DefaultObjectSerializerDelegate;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.CorrelationIdGenerator;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.internal.config.ExpressionCorrelationIdGenerator;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class MuleConfigurationConfigurator
extends AbstractComponentFactory<MuleConfiguration>
implements SmartFactoryBean<MuleConfiguration> {
    private MuleContext muleContext;
    @Inject
    private DefaultObjectSerializerDelegate objectSerializerDelegate;
    @Inject
    private TimeSupplier timeSupplier;
    @Inject
    private ExpressionManager expressionManager;
    private final DefaultMuleConfiguration config = new DefaultMuleConfiguration();
    private boolean explicitDynamicConfigExpiration;
    private OptionalLong shutdownTimeout = OptionalLong.empty();

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    private void applyDefaultIfNoObjectSerializerSet(DefaultMuleConfiguration configuration) {
        ObjectSerializer configuredSerializer = this.config.getDefaultObjectSerializer();
        if (configuredSerializer != null) {
            configuration.setDefaultObjectSerializer(configuredSerializer);
            this.objectSerializerDelegate.setDelegate(configuredSerializer);
            if (this.muleContext instanceof DefaultMuleContext) {
                ((DefaultMuleContext)this.muleContext).setObjectSerializer(configuredSerializer);
            }
        }
    }

    public Class<?> getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        this.config.setDefaultResponseTimeout(responseTimeout);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = OptionalLong.of(shutdownTimeout);
    }

    public void setDefaultErrorHandlerName(String defaultErrorHandlerName) {
        this.config.setDefaultErrorHandlerName(defaultErrorHandlerName);
    }

    public void setDefaultObjectSerializer(ObjectSerializer objectSerializer) {
        this.config.setDefaultObjectSerializer(objectSerializer);
    }

    public void setMaxQueueTransactionFilesSize(int queueTransactionFilesSizeInMegabytes) {
        this.config.setMaxQueueTransactionFilesSize(queueTransactionFilesSizeInMegabytes);
    }

    public void setDynamicConfigExpiration(DynamicConfigExpiration dynamicConfigExpiration) {
        this.explicitDynamicConfigExpiration = true;
        this.config.setDynamicConfigExpiration(dynamicConfigExpiration);
    }

    public void setInheritIterableRepeatability(String inheritIterableRepeatability) {
        this.config.setInheritIterableRepeatability(inheritIterableRepeatability);
    }

    public void setCorrelationIdGeneratorExpression(String correlationIdGeneratorExpression) {
        this.config.setDefaultCorrelationIdGenerator((CorrelationIdGenerator)new ExpressionCorrelationIdGenerator(this.expressionManager, correlationIdGeneratorExpression));
    }

    public void setExtensions(List<ConfigurationExtension> extensions) {
        this.config.addExtensions(extensions);
    }

    public MuleConfiguration doGetObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            DefaultMuleConfiguration defaultConfig = (DefaultMuleConfiguration)configuration;
            defaultConfig.setDefaultResponseTimeout(this.config.getDefaultResponseTimeout());
            defaultConfig.setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            defaultConfig.setShutdownTimeout(this.shutdownTimeout.orElseGet(() -> {
                String defaultValue = System.getProperty("mule.gracefulShutdown.defaultTimeout", System.getenv("mule.gracefulShutdown.defaultTimeout".toUpperCase().replaceAll("\\.", "_")));
                if (defaultValue == null) {
                    return 5000L;
                }
                return Long.parseLong(defaultValue);
            }));
            defaultConfig.setDefaultErrorHandlerName(this.config.getDefaultErrorHandlerName());
            defaultConfig.addExtensions(this.config.getExtensions());
            defaultConfig.setMaxQueueTransactionFilesSize(this.config.getMaxQueueTransactionFilesSizeInMegabytes());
            defaultConfig.setDynamicConfigExpiration(this.resolveDynamicConfigExpiration());
            defaultConfig.setInheritIterableRepeatability(this.config.isInheritIterableRepeatability());
            this.config.getDefaultCorrelationIdGenerator().ifPresent(generator -> defaultConfig.setDefaultCorrelationIdGenerator(generator));
            this.applyDefaultIfNoObjectSerializerSet(defaultConfig);
            return configuration;
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)("Unable to set properties on read-only MuleConfiguration: " + String.valueOf(configuration.getClass()))));
    }

    private DynamicConfigExpiration resolveDynamicConfigExpiration() {
        if (this.explicitDynamicConfigExpiration) {
            return this.config.getDynamicConfigExpiration();
        }
        return DynamicConfigExpiration.getDefault((TimeSupplier)this.timeSupplier);
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

