/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.mule.service.http.netty.impl.server.MultiplexerChannelInitializer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

class UpgradeToHttp2CleartextCodecFactory
implements HttpServerUpgradeHandler.UpgradeCodecFactory {
    private final HttpListenerRegistry httpListenerRegistry;
    private final Executor ioExecutor;

    public UpgradeToHttp2CleartextCodecFactory(HttpListenerRegistry httpListenerRegistry, Executor ioExecutor) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.ioExecutor = ioExecutor;
    }

    public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
            return new UpdateCodecWithErrorResponse((HttpServerUpgradeHandler.UpgradeCodec)new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new MultiplexerChannelInitializer(this.httpListenerRegistry, null, this.ioExecutor))}));
        }
        return null;
    }

    private static final class UpdateCodecWithErrorResponse
    implements HttpServerUpgradeHandler.UpgradeCodec {
        private final HttpServerUpgradeHandler.UpgradeCodec delegate;

        private UpdateCodecWithErrorResponse(HttpServerUpgradeHandler.UpgradeCodec delegate) {
            this.delegate = delegate;
        }

        public Collection<CharSequence> requiredUpgradeHeaders() {
            return this.delegate.requiredUpgradeHeaders();
        }

        public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
            if (this.delegate.prepareUpgradeResponse(ctx, upgradeRequest, upgradeHeaders)) {
                return true;
            }
            ByteBuf responseMsg = Unpooled.buffer();
            ByteBufUtil.writeUtf8((ByteBuf)responseMsg, (CharSequence)"HTTP Upgrade request to HTTP2 failed");
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(upgradeRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST, responseMsg));
            ctx.fireExceptionCaught((Throwable)new IllegalArgumentException("HTTP Upgrade Request was rejected"));
            return false;
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
            this.delegate.upgradeTo(ctx, upgradeRequest);
        }
    }
}

