/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceUtils;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.internal.util.ClassUtils;

public class InjectParamsFromContextServiceProxy
extends MetadataInvocationHandler<Service> {
    private final LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache;
    private final LoadingCache<String, Optional<?>> lookupByNameCache;

    public InjectParamsFromContextServiceProxy(Service service, Registry registry) {
        super((Object)service);
        Objects.requireNonNull(registry, "registry cannot be null");
        this.lookupAllByTypeCache = Caffeine.newBuilder().build(arg_0 -> ((Registry)registry).lookupAllByType(arg_0));
        this.lookupByNameCache = Caffeine.newBuilder().build(arg_0 -> ((Registry)registry).lookupByName(arg_0));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method injectable = this.resolveInjectableMethod(method);
        if (injectable == null) {
            return this.doInvoke(proxy, method, args);
        }
        ArrayList<Object> augmentedArgs = args == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(args));
        for (int i = method.getParameters().length; i < injectable.getParameters().length; ++i) {
            Parameter parameter = injectable.getParameters()[i];
            augmentedArgs.add(InjectParamsFromContextServiceUtils.calculateAugmentedArgForParamerter(parameter, this.lookupByNameCache, this.lookupAllByTypeCache, injectable, ((Service)this.getProxiedObject()).getName()));
        }
        return this.doInvoke(proxy, injectable, augmentedArgs.toArray());
    }

    private Method resolveInjectableMethod(Method method) {
        Method candidate = null;
        for (Method serviceImplMethod : this.getImplementationDeclaredMethods()) {
            candidate = InjectParamsFromContextServiceUtils.resolveInjectableMethodFor(method, serviceImplMethod, this.lookupAllByTypeCache, candidate, ((Service)this.getProxiedObject()).getName());
        }
        return candidate;
    }

    public static Service createInjectProviderParamsServiceProxy(Service service, Registry registry) {
        Objects.requireNonNull(service, "service cannot be null");
        Objects.requireNonNull(registry, "registry cannot be null");
        InjectParamsFromContextServiceProxy handler = new InjectParamsFromContextServiceProxy(service, registry);
        return (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.findImplementedInterfaces(service.getClass()), (InvocationHandler)((Object)handler));
    }
}

