/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.rx;

import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class Exceptions {
    private static final String REACTIVE_EXCEPTION_CLASS_NAME = "reactor.core.Exceptions$ReactiveException";

    public static MuleException rxExceptionToMuleException(Throwable throwable) throws MuleException {
        if ((throwable = Exceptions.unwrap(throwable)) instanceof MuleException) {
            return (MuleException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new DefaultMuleException(throwable);
    }

    public static Throwable unwrap(Throwable throwable) {
        while (throwable.getClass().getName().equals(REACTIVE_EXCEPTION_CLASS_NAME)) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static RuntimeException propagateWrappingFatal(Throwable t) {
        return reactor.core.Exceptions.propagate((Throwable)Exceptions.wrapFatal(t));
    }

    public static Throwable wrapFatal(Throwable t) {
        if (t instanceof LinkageError) {
            return new MuleFatalException(t);
        }
        if (t instanceof VirtualMachineError) {
            return new MuleFatalException(t);
        }
        if (reactor.core.Exceptions.isBubbling((Throwable)t)) {
            return new MuleRuntimeException(Exceptions.unwrap(t));
        }
        if (reactor.core.Exceptions.isErrorCallbackNotImplemented((Throwable)t)) {
            return new MuleRuntimeException(Exceptions.unwrap(t));
        }
        return t;
    }

    private Exceptions() {
    }
}

