/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.export.sniffer;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.runtime.logging.otel.impl.export.sniffer.ExportedLogRecordSniffer;
import org.mule.runtime.logging.otel.impl.export.sniffer.SniffedLogRecord;

public class SniffedLogRecordExporter
implements LogRecordExporter {
    private final LogRecordExporter delegate;
    private final List<InternalExportedLogRecordSniffer> exportedLogRecordSniffers = new ArrayList<InternalExportedLogRecordSniffer>(1);

    public SniffedLogRecordExporter(LogRecordExporter delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        this.exportedLogRecordSniffers.forEach(exportedLogRecordSniffer -> exportedLogRecordSniffer.sniff(logs));
        return this.delegate.export(logs);
    }

    public CompletableResultCode flush() {
        return this.delegate.flush();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public void close() {
        super.close();
        this.delegate.close();
    }

    public ExportedLogRecordSniffer getExportedLogRecordSniffer() {
        InternalExportedLogRecordSniffer exportedLogRecordSniffer = new InternalExportedLogRecordSniffer();
        this.exportedLogRecordSniffers.add(exportedLogRecordSniffer);
        return exportedLogRecordSniffer;
    }

    private static class InternalExportedLogRecordSniffer
    implements ExportedLogRecordSniffer {
        private final List<SniffedLogRecord> sniffedLogRecords = new CopyOnWriteArrayList<SniffedLogRecord>();

        private InternalExportedLogRecordSniffer() {
        }

        public void sniff(Collection<LogRecordData> sniffedLogRecord) {
            sniffedLogRecord.stream().map(InternalSniffedLogRecord::new).forEach(this.sniffedLogRecords::add);
        }

        @Override
        public List<SniffedLogRecord> getSniffedLogRecords() {
            return this.sniffedLogRecords;
        }
    }

    private static class InternalSniffedLogRecord
    implements SniffedLogRecord {
        LogRecordData sniffedLogRecord;

        public InternalSniffedLogRecord(LogRecordData sniffedLogRecord) {
            this.sniffedLogRecord = sniffedLogRecord;
        }

        @Override
        public String getBody() {
            return this.sniffedLogRecord.getBodyValue() != null ? this.sniffedLogRecord.getBodyValue().asString() : "";
        }

        @Override
        public String getSpanId() {
            return this.sniffedLogRecord.getSpanContext().getSpanId();
        }

        @Override
        public String getTraceId() {
            return this.sniffedLogRecord.getSpanContext().getTraceId();
        }

        @Override
        public String getSeverity() {
            return this.sniffedLogRecord.getSeverity().toString();
        }
    }
}

