/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.IOException;
import org.jsoup.SerializationException;

public abstract class QuietAppendable {
    public abstract QuietAppendable append(CharSequence var1);

    public abstract QuietAppendable append(char var1);

    public abstract QuietAppendable append(char[] var1, int var2, int var3);

    public static QuietAppendable wrap(Appendable a) {
        if (a instanceof StringBuilder) {
            return new StringBuilderAppendable((StringBuilder)a);
        }
        return new BaseAppendable(a);
    }

    static final class StringBuilderAppendable
    extends QuietAppendable {
        private final StringBuilder sb;

        private StringBuilderAppendable(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public StringBuilderAppendable append(CharSequence csq) {
            this.sb.append(csq);
            return this;
        }

        @Override
        public StringBuilderAppendable append(char c) {
            this.sb.append(c);
            return this;
        }

        @Override
        public QuietAppendable append(char[] chars, int offset, int len) {
            this.sb.append(chars, offset, len);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static final class BaseAppendable
    extends QuietAppendable {
        private final Appendable a;

        private BaseAppendable(Appendable appendable) {
            this.a = appendable;
        }

        private BaseAppendable quiet(Action action) {
            try {
                action.append();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
            return this;
        }

        @Override
        public BaseAppendable append(CharSequence csq) {
            return this.quiet(() -> this.a.append(csq));
        }

        @Override
        public BaseAppendable append(char c) {
            return this.quiet(() -> this.a.append(c));
        }

        @Override
        public QuietAppendable append(char[] chars, int offset, int len) {
            return this.quiet(() -> this.a.append(new String(chars, offset, len)));
        }

        @FunctionalInterface
        private static interface Action {
            public void append() throws IOException;
        }
    }
}

