/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.store;

import java.io.Serializable;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

@NoExtend
public abstract class AbstractObjectStoreSupport<T extends Serializable>
implements ObjectStore<T> {
    protected void validateKey(String key) throws ObjectStoreException {
        if (key == null || key.trim().length() == 0) {
            throw new ObjectStoreException(I18nMessageFactory.createStaticMessage("key cannot be null or blank"));
        }
    }

    protected void validatePresentKey(String key) throws ObjectStoreException {
        this.validateKey(key);
        if (!this.contains(key)) {
            throw new ObjectDoesNotExistException(I18nMessageFactory.createStaticMessage("Key does not exist: " + key));
        }
    }
}

