/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.CorrelationIdGenerator;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;

public class ExpressionCorrelationIdGenerator
implements CorrelationIdGenerator {
    private final String expression;
    private final ExpressionManager expressionManager;
    private CompiledExpression compiledExpression;

    public ExpressionCorrelationIdGenerator(ExpressionManager expressionManager, String expression) {
        this.expressionManager = expressionManager;
        this.expression = expression;
    }

    @Override
    public String generateCorrelationId() {
        try (ExpressionManagerSession session = this.expressionManager.openSession(BindingContextUtils.NULL_BINDING_CONTEXT);){
            String string = session.evaluate(this.compiledExpression).getValue().toString();
            return string;
        }
    }

    private void validateExpression() {
        if (!this.expressionManager.isExpression(this.expression) || !this.expressionManager.isValid(this.expression)) {
            throw new ExpressionCompilationException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid Correlation ID Generation expression: %s", this.expression)));
        }
    }

    public void initializeGenerator() {
        this.compiledExpression = this.expressionManager.compile(this.expression, BindingContextUtils.NULL_BINDING_CONTEXT);
        this.validateExpression();
    }
}

