/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Objects;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static String serializeMetadataType(Object object) {
        Objects.requireNonNull(object, "'object' to serialize cannot not be null");
        Gson gson = new GsonBuilder().registerTypeAdapter(MetadataType.class, (Object)new MetadataTypeGsonTypeAdapter()).create();
        return gson.toJson(object);
    }

    public static <T> T deserializeMetadataType(String json, Type type) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(MetadataType.class, (Object)new MetadataTypeGsonTypeAdapter()).create();
            return (T)gson.fromJson(json, type);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("The serialized content does not match the expected format", e);
        }
    }
}

