/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction.xa;

import jakarta.transaction.TransactionManager;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.transaction.XaTransaction;
import org.mule.runtime.core.privileged.transaction.TransactionFactory;

@NoExtend
public class XaTransactionFactory
implements TransactionFactory {
    private int timeout;
    private TransactionManager transactionManager;

    @Override
    public Transaction beginTransaction(String applicationName, NotificationDispatcher notificationFirer) throws TransactionException {
        try {
            XaTransaction xat = new XaTransaction(applicationName, this.transactionManager, notificationFirer);
            xat.setTimeout(this.timeout);
            xat.begin();
            return xat;
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

