/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTimeoutThrottleRequestFilter
implements RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(CustomTimeoutThrottleRequestFilter.class);
    private final Semaphore available;

    public CustomTimeoutThrottleRequestFilter(int maxConnections) {
        this.available = new Semaphore(maxConnections, true);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        try {
            int timeout = ctx.getRequest().getRequestTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug("Current available connections: {}, Maximum wait time: {}", (Object)this.available.availablePermits(), (Object)timeout);
            }
            if (!this.available.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                logger.debug("Rejecting request {} in AsyncHandler {}", (Object)ctx.getRequest(), (Object)ctx.getAsyncHandler());
                throw new FilterException("Connection limit exceeded, cannot process request");
            }
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted request {} in AsyncHandler {}", (Object)ctx.getRequest(), (Object)ctx.getAsyncHandler());
            throw new FilterException("Interrupted request");
        }
        return new FilterContext.FilterContextBuilder(ctx).asyncHandler(new AsyncHandlerWrapper(this.resolveAsyncHandler(ctx))).build();
    }

    protected AsyncHandler resolveAsyncHandler(FilterContext ctx) {
        return ctx.getAsyncHandler();
    }

    private class AsyncHandlerWrapper<T>
    implements AsyncHandler<T> {
        private final AsyncHandler<T> asyncHandler;
        private final AtomicBoolean complete = new AtomicBoolean(false);

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
        }

        private void complete() {
            if (this.complete.compareAndSet(false, true)) {
                CustomTimeoutThrottleRequestFilter.this.available.release();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Current available connections after processing: {}", (Object)CustomTimeoutThrottleRequestFilter.this.available.availablePermits());
            }
        }

        public void onThrowable(Throwable t) {
            this.complete();
            this.asyncHandler.onThrowable(t);
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return this.asyncHandler.onStatusReceived(responseStatus);
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }

        public T onCompleted() throws Exception {
            try {
                Object object = this.asyncHandler.onCompleted();
                return (T)object;
            }
            finally {
                this.complete();
            }
        }
    }
}

