/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.RouterStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.routing.AbstractSinkRouter;
import org.mule.runtime.core.internal.routing.ExecutableRoute;
import org.mule.runtime.core.internal.routing.ProcessorExpressionRoute;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.routing.result.RouterStatisticsRecorder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ChoiceRouter
extends AbstractComponent
implements Router,
RouterStatisticsRecorder,
Lifecycle,
MuleContextAware {
    public static final String ROUTE_SPAN_NAME_SUFFIX = ":route";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final List<ProcessorRoute> routes = new ArrayList<ProcessorRoute>();
    private Processor defaultProcessor;
    private RouterStatistics routerStatistics = new RouterStatistics(2);
    private MuleContext muleContext;
    private ExpressionManager expressionManager;
    private ComponentTracerFactory componentTracerFactory;

    public ChoiceRouter(ComponentTracerFactory componentTracerFactory) {
        this.componentTracerFactory = componentTracerFactory;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Inject
    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public void initialise() throws InitialisationException {
        if (this.defaultProcessor == null) {
            this.defaultProcessor = event -> event;
        }
        this.routes.add(new ProcessorRoute(this.defaultProcessor, this.componentTracerFactory));
        for (ProcessorRoute route : this.routes) {
            route.setComponentTracer(this.componentTracerFactory.fromComponent((Component)this, ROUTE_SPAN_NAME_SUFFIX));
            LifecycleUtils.initialiseIfNeeded((Object)((Object)route), (MuleContext)this.muleContext);
        }
    }

    public void start() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.start();
        }
        this.started.set(true);
    }

    public void stop() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.stop();
        }
        this.started.set(false);
    }

    public void dispose() {
        for (ProcessorRoute route : this.routes) {
            route.dispose();
        }
    }

    public void addRoute(String expression, Processor processor) {
        this.routes.add(new ProcessorExpressionRoute(expression, processor, this.componentTracerFactory));
    }

    public void setDefaultRoute(Processor processor) {
        this.defaultProcessor = processor;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.merge(new SinkRouter(publisher, this.routes).collectPublishers());
    }

    public void updateStatistics(Processor processor) {
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage((Object)processor);
        }
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public String toString() {
        return String.format("%s [flow=%s, started=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getLocation().getRootContainerName(), this.started);
    }

    private class SinkRouter
    extends AbstractSinkRouter {
        SinkRouter(Publisher<CoreEvent> publisher, List<ProcessorRoute> routes) {
            super(publisher, routes, ChoiceRouter.this.componentTracerFactory);
        }

        @Override
        protected void route(CoreEvent event) {
            ExecutableRoute selectedRoute;
            try (ExpressionManagerSession session = ChoiceRouter.this.expressionManager.openSession(ChoiceRouter.this.getLocation(), event, BindingContextUtils.NULL_BINDING_CONTEXT);){
                selectedRoute = this.getRoutes().stream().filter(route -> route.shouldExecute(session)).findFirst().get();
            }
            selectedRoute.execute(event);
            ChoiceRouter.this.updateStatistics(selectedRoute.getProcessor());
        }
    }
}

