/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.common.server.sse.FutureCompleterCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.util.AsyncEntityReader;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.junit4.matcher.FunctionExpressionMatcher;
import org.mule.tck.junit5.DynamicPort;
import org.mule.tck.probe.PollingProber;

@Feature(value="HTTP/2 Support")
@Story(value="Deferred HTTP/2 responses")
class Http2DeferringResponsePayloadTestCase
extends AbstractHttpServiceTestCase {
    private static final int RESP_TIMEOUT_MS = 4000;
    private static final int CHUNK_SIZE = 8192;
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private HttpServer httpServer;
    private HttpClient httpClient;
    private final CompletableFuture<Writer> capturedResponseWriter = new CompletableFuture();
    private final CompletableFuture<Void> responseStatusFuture = new CompletableFuture();
    private final ResponseStatusCallback responseStatusCallback = new FutureCompleterCallback(this.responseStatusFuture);
    private final Latch receivedRequest = new Latch();
    private final Latch readyToSendResponse = new Latch();

    public Http2DeferringResponsePayloadTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpServer = this.createServer();
        this.httpClient = this.createClient();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        this.httpServer.stop().dispose();
    }

    @Test
    void writeInParts() throws ExecutionException, InterruptedException, IOException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        HttpResponse response = (HttpResponse)this.httpClient.sendAsync(request).get();
        AsyncEntityReader asyncReader = new AsyncEntityReader(response);
        executorService.submit(asyncReader);
        Writer writer = this.capturedResponseWriter.get();
        writer.write("Chunk 1\n");
        writer.write("Chunk 2\n");
        writer.write("Chunk 3\n");
        writer.flush();
        Http2DeferringResponsePayloadTestCase.checkPayload(asyncReader, "Chunk 1\nChunk 2\nChunk 3\n");
        MatcherAssert.assertThat((Object)asyncReader.finished(), (Matcher)Matchers.is((Object)false));
        writer.write("Chunk 4\n");
        writer.flush();
        writer.close();
        Http2DeferringResponsePayloadTestCase.checkPayload(asyncReader, "Chunk 1\nChunk 2\nChunk 3\nChunk 4\n");
        MatcherAssert.assertThat((Object)asyncReader.finished(), (Matcher)Matchers.is((Object)true));
        Assertions.assertDoesNotThrow(() -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void whenSendingResponseFailsFlushingThenCallbackIsCalled() throws InterruptedException, ExecutionException, TimeoutException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/testLatched".formatted(this.serverPort)).build();
        CompletableFuture resp = this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(100).build());
        this.receivedRequest.await();
        MatcherAssert.assertThat((Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, resp::get)), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)IsInstanceOf.instanceOf(TimeoutException.class)));
        this.readyToSendResponse.release();
        Writer writer = this.capturedResponseWriter.get(4000L, TimeUnit.MILLISECONDS);
        char[] chunk = new char[8192];
        Arrays.fill(chunk, 'x');
        PollingProber.probe((long)4000L, (long)50L, () -> {
            writer.write(chunk);
            writer.flush();
            return this.responseStatusFuture.isDone();
        });
        MatcherAssert.assertThat((Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.responseStatusFuture.get(4000L, TimeUnit.MILLISECONDS))), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)IsInstanceOf.instanceOf(ClosedChannelException.class)));
    }

    private static void checkPayload(AsyncEntityReader asyncReader, String expectedContent) {
        MatcherAssert.assertThat((Object)asyncReader, (Matcher)Eventually.eventually((Matcher)FunctionExpressionMatcher.expressionMatches(AsyncEntityReader::partialPayload, (Matcher)Matchers.equalToCompressingWhiteSpace((String)expectedContent))));
    }

    private HttpClient createClient() throws CreateException {
        HttpClient client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp2Config(new Http2ProtocolConfig(true)).setStreaming(true).setTlsContextFactory(TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").insecureTrustStore(true).build()).build());
        client.start();
        return client;
    }

    private HttpServer createServer() throws ServerCreationException, IOException, CreateException {
        HttpServer server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setName("HTTP/2 Server").setHost("localhost").setPort(this.serverPort.intValue()).setHttp2Config(new Http2ProtocolConfig(true)).setTlsContextFactory(TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").build()).build());
        server.start();
        server.addRequestHandler("/test", (ctx, callback) -> this.capturedResponseWriter.complete(callback.startResponse(HttpResponse.builder().build(), this.responseStatusCallback, StandardCharsets.UTF_8)));
        server.addRequestHandler("/testLatched", (ctx, callback) -> {
            this.receivedRequest.release();
            try {
                this.readyToSendResponse.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.capturedResponseWriter.complete(callback.startResponse(HttpResponse.builder().build(), this.responseStatusCallback, StandardCharsets.UTF_8));
        });
        return server;
    }
}

