/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.interception.ParametersResolverProcessor;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.processor.strategy.ComponentInnerProcessor;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.ChainErrorHandlingUtils;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.core.privileged.transaction.TransactionFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.operation.adapter.SdkOperationTransactionalActionUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.retry.ComponentRetryPolicyTemplateResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.retry.RetryPolicyTemplateResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.RouteBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.result.PayloadTargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.tracing.TracedResolverSet;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.InterceptorChainUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.mule.sdk.api.tx.OperationTransactionalAction;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.core.publisher.Flux;
import reactor.util.context.ContextView;

public abstract class ComponentMessageProcessor<T extends ComponentModel>
extends ExtensionComponent<T>
implements Processor,
ParametersResolverProcessor<T>,
Lifecycle {
    public static final String PROCESSOR_PATH_MDC_KEY = "processorPath";
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessor.class);
    private static final ExtensionTransactionFactory TRANSACTION_FACTORY = new ExtensionTransactionFactory();
    protected final ExtensionModel extensionModel;
    protected ResolverSet resolverSet;
    protected final String target;
    protected final String targetValue;
    protected final RetryPolicyTemplate retryPolicyTemplate;
    protected final MessageProcessorChain nestedChain;
    private final ReflectionCache reflectionCache;
    private final ResultTransformer resultTransformer;
    private final boolean hasNestedChain;
    private final long outerFluxTerminationTimeout;
    private final Object fluxSupplierLock = new Object();
    private final AtomicInteger activeOuterPublishersCount = new AtomicInteger(0);
    protected ExecutionMediator executionMediator;
    protected CompletableComponentExecutor componentExecutor;
    protected ReturnDelegate returnDelegate;
    protected ClassLoader nestedChainClassLoader;
    private Optional<TransactionConfig> transactionConfig;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private ExtensionConnectionSupplier extensionConnectionSupplier;
    @Inject
    private InternalProfilingService profilingService;
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private MuleConfiguration muleConfiguration;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private ArtifactEncoding artifactEncoding;
    @Inject
    private Optional<PolicyManager> policyManager;
    private Function<Optional<ConfigurationInstance>, RetryPolicyTemplate> retryPolicyResolver;
    private String resolvedProcessorRepresentation;
    private boolean initialised = false;
    private ProcessingStrategy processingStrategy;
    private boolean ownedProcessingStrategy = false;
    private volatile FluxSinkSupplier<CoreEvent> fluxSupplier;
    private Scheduler outerFluxCompletionScheduler;
    private ReturnDelegate valueReturnDelegate;
    private String processorPath = null;
    private ComponentTracer<CoreEvent> operationParametersResolutionTracer = DummyComponentTracerFactory.DUMMY_COMPONENT_TRACER_INSTANCE;

    public ComponentMessageProcessor(ExtensionModel extensionModel, T componentModel, ValueResolver<ConfigurationProvider> configurationProviderResolver, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, MessageProcessorChain nestedChain, ClassLoader classLoader, ExtensionManager extensionManager, ReflectionCache reflectionCache, ResultTransformer resultTransformer, long terminationTimeout) {
        super(extensionModel, componentModel, configurationProviderResolver, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.targetValue = targetValue;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.nestedChain = nestedChain;
        this.nestedChainClassLoader = classLoader;
        this.reflectionCache = reflectionCache;
        this.resultTransformer = resultTransformer;
        this.hasNestedChain = this.hasNestedChain(componentModel);
        this.outerFluxTerminationTimeout = terminationTimeout;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        BiFunction localOperatorErrorHook = ChainErrorHandlingUtils.getLocalOperatorErrorHook((Processor)this, (ErrorTypeLocator)this.errorTypeLocator, this.exceptionContextProviders);
        boolean mayCompleteInDifferentThread = this.mayCompleteInDifferentThread();
        ComponentLocation location = this.getLocation();
        return Flux.deferContextual(ctx -> {
            Flux transformed = this.createOuterFlux((Flux<CoreEvent>)Flux.from((Publisher)publisher), localOperatorErrorHook, mayCompleteInDifferentThread, (ContextView)ctx).doOnNext(result -> this.removeSdkInternalContextFromResult(location, (Either<Throwable, CoreEvent>)result)).map(RxUtils.propagateErrorResponseMapper());
            if (publisher instanceof Flux && !ctx.getOrEmpty((Object)"messageProcessors.withinProcessToApply").isPresent()) {
                return transformed.doAfterTerminate(this::outerPublisherTerminated).doOnSubscribe(s -> this.outerPublisherSubscribedTo());
            }
            return transformed;
        });
    }

    private void removeSdkInternalContextFromResult(ComponentLocation location, Either<Throwable, CoreEvent> result) {
        result.apply(me -> this.removeSdkInternalContext(location, ((MessagingException)me).getEvent()), response -> this.removeSdkInternalContext(location, (CoreEvent)response));
    }

    private void removeSdkInternalContext(ComponentLocation location, CoreEvent event) {
        SdkInternalContext sdkCtx = SdkInternalContext.from(event);
        if (sdkCtx != null) {
            sdkCtx.removeContext(location, event.getContext().getId());
        }
    }

    private Flux<Either<Throwable, CoreEvent>> createOuterFlux(Flux<CoreEvent> publisher, final BiFunction<Throwable, Object, Throwable> localOperatorErrorHook, boolean mayCompleteInDifferentThread, ContextView ctx) {
        final FluxSinkRecorder errorSwitchSinkSinkRef = new FluxSinkRecorder();
        Function<Publisher, Publisher> transformer = pub -> Flux.from((Publisher)pub).mapNotNull(event -> {
            try {
                return this.addContextToEvent((CoreEvent)event, ctx);
            }
            catch (Exception t) {
                Throwable mapped = (Throwable)localOperatorErrorHook.apply(t, event);
                if (this.outerFluxTerminationTimeout < 0L || ((Boolean)ctx.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
                    errorSwitchSinkSinkRef.next((Object)Either.left((Object)mapped, CoreEvent.class));
                    return null;
                }
                throw Exceptions.propagateWrappingFatal((Throwable)mapped);
            }
        }).doOnNext(event -> {
            CompletableComponentExecutor.ExecutorCallback executorCallback = new CompletableComponentExecutor.ExecutorCallback(){
                final /* synthetic */ CoreEvent val$event;
                {
                    this.val$event = coreEvent;
                }

                public void error(Throwable e) {
                    errorSwitchSinkSinkRef.next((Object)Either.left((Object)((Throwable)localOperatorErrorHook.apply(e, this.val$event)), CoreEvent.class));
                }

                public void complete(Object value) {
                    errorSwitchSinkSinkRef.next((Object)Either.right(Throwable.class, (Object)((CoreEvent)value)));
                }
            };
            if (!mayCompleteInDifferentThread && SdkInternalContext.from(event).isNoPolicyOperation(this.getLocation(), event.getContext().getId())) {
                this.onEventSynchronous((CoreEvent)event, executorCallback, ctx);
            } else {
                this.onEvent((CoreEvent)event, executorCallback, ctx);
            }
        }).map(e -> Either.empty());
        if (this.outerFluxTerminationTimeout < 0L || ((Boolean)ctx.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
            return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from(publisher), (Publisher)errorSwitchSinkSinkRef.flux(), transformer, () -> errorSwitchSinkSinkRef.complete(), t -> errorSwitchSinkSinkRef.error(t)));
        }
        return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from(publisher), (Publisher)errorSwitchSinkSinkRef.flux(), transformer, () -> errorSwitchSinkSinkRef.complete(), t -> errorSwitchSinkSinkRef.error(t), (long)this.outerFluxTerminationTimeout, (ScheduledExecutorService)this.outerFluxCompletionScheduler, (String)this.getDslSource()));
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        if (this.mayCompleteInDifferentThread()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE;
        }
        return this.getInnerProcessingType();
    }

    private void onEvent(CoreEvent event, CompletableComponentExecutor.ExecutorCallback executorCallback, ContextView ctx) {
        try {
            if (this.fluxSupplier == null) {
                throw new NullPointerException("fluxSupplier null in component executor for " + String.valueOf(this.getLocation().getComponentIdentifier().getIdentifier()) + " at " + this.getLocation().getLocation());
            }
            SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
            ComponentLocation location = this.getLocation();
            String eventId = event.getContext().getId();
            Optional<ConfigurationInstance> configuration = sdkInternalContext.getConfiguration(location, eventId);
            Map<String, Object> resolutionResult = sdkInternalContext.getResolutionResult(location, eventId);
            OperationExecutionFunction operationExecutionFunction = (parameters, operationEvent, callback) -> {
                this.setOperationExecutionParams(location, event, configuration, parameters, operationEvent, callback, ctx);
                this.fluxSupplier.get(ctx).next((Object)operationEvent);
            };
            if (location != null) {
                ((DefaultFlowCallStack)event.getFlowCallStack()).pushCurrentProcessorPath(this.resolvedProcessorRepresentation, this.getLocation(), this.getAnnotations());
                CompletableComponentExecutor.ExecutorCallback effectiveCallback = this.isTargetWithPolicies(event) ? this.getExecutionCallbackForPolicyAndOperationWithTarget(event, executorCallback) : executorCallback;
                sdkInternalContext.getPolicyToApply(location, eventId).process(event, operationExecutionFunction, () -> resolutionResult, location, effectiveCallback);
            } else {
                operationExecutionFunction.execute(resolutionResult, event, executorCallback);
            }
        }
        catch (Throwable t) {
            executorCallback.error(Exceptions.unwrap((Throwable)t));
        }
    }

    private void onEventSynchronous(CoreEvent event, CompletableComponentExecutor.ExecutorCallback executorCallback, ContextView ctx) {
        try {
            SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
            ComponentLocation location = this.getLocation();
            String eventId = event.getContext().getId();
            Optional<ConfigurationInstance> configuration = sdkInternalContext.getConfiguration(location, eventId);
            Map<String, Object> resolutionResult = sdkInternalContext.getResolutionResult(location, eventId);
            OperationExecutionFunction operationExecutionFunction = (parameters, operationEvent, callback) -> {
                this.setOperationExecutionParams(location, event, configuration, parameters, operationEvent, callback, ctx);
                this.prepareAndExecuteOperation(event, () -> callback);
            };
            CompletableComponentExecutor.ExecutorCallback effectiveCallback = this.isTargetWithPolicies(event) ? this.getExecutionCallbackForPolicyAndOperationWithTarget(event, executorCallback) : executorCallback;
            operationExecutionFunction.execute(resolutionResult, event, effectiveCallback);
        }
        catch (Throwable t) {
            executorCallback.error(Exceptions.unwrap((Throwable)t));
        }
    }

    private CompletableComponentExecutor.ExecutorCallback getExecutionCallbackForPolicyAndOperationWithTarget(final CoreEvent event, final CompletableComponentExecutor.ExecutorCallback delegateCallback) {
        return new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object o) {
                ExecutionContextAdapter<Object> operationContext = null;
                try {
                    SdkInternalContext.OperationExecutionParams operationExecutionParams = ComponentMessageProcessor.this.getOperationExecutionParams(event);
                    if (operationExecutionParams != null) {
                        operationContext = operationExecutionParams.executionContextAdapter();
                        operationContext.changeEvent(event);
                    } else {
                        operationContext = ComponentMessageProcessor.this.createExecutionContext(event);
                    }
                    delegateCallback.complete((Object)ComponentMessageProcessor.this.returnDelegate.asReturnValue(o, operationContext));
                }
                catch (MuleException e) {
                    delegateCallback.error((Throwable)e);
                }
                catch (Throwable t) {
                    delegateCallback.error(Exceptions.unwrap((Throwable)t));
                }
            }

            public void error(Throwable t) {
                delegateCallback.error(Exceptions.unwrap((Throwable)t));
            }
        };
    }

    private CompletableComponentExecutor.ExecutorCallback mapped(final CompletableComponentExecutor.ExecutorCallback callback, final ExecutionContextAdapter<T> operationContext, final ReturnDelegate delegate) {
        return new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                callback.complete((Object)delegate.asReturnValue(value, operationContext));
            }

            public void error(Throwable t) {
                callback.error(Exceptions.unwrap((Throwable)t));
            }
        };
    }

    private boolean isTargetWithPolicies(CoreEvent event) {
        return !SdkInternalContext.from(event).isNoPolicyOperation(this.getLocation(), event.getContext().getId()) && !StringUtils.isBlank((CharSequence)this.target);
    }

    private Optional<ConfigurationInstance> resolveConfiguration(CoreEvent event) {
        if (this.shouldUsePrecalculatedContext(event)) {
            return this.getPrecalculatedContext(event).getConfiguration();
        }
        return this.getConfiguration(event);
    }

    private boolean shouldUsePrecalculatedContext(CoreEvent event) {
        ComponentLocation location = this.getLocation();
        return location != null && this.isInterceptedComponent(location, (InternalEvent)event) && this.getPrecalculatedContext(event) != null;
    }

    private PrecalculatedExecutionContextAdapter<T> getPrecalculatedContext(CoreEvent event) {
        return (PrecalculatedExecutionContextAdapter)((InternalEvent)event).getInternalParameter("core:interceptionResolvedContext");
    }

    protected void executeOperation(ExecutionContextAdapter<T> operationContext, CompletableComponentExecutor.ExecutorCallback callback) {
        this.executionMediator.execute(this.componentExecutor, operationContext, callback);
    }

    private ExecutionContextAdapter<T> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, CoreEvent event, Scheduler currentScheduler) {
        return new DefaultExecutionContext<ComponentModel>(this.extensionModel, configuration, resolvedParameters, this.componentModel, event, this.artifactEncoding, this.muleContext.getNotificationManager(), this.getCursorProviderFactory(), this.streamingManager, (Component)this, this.retryPolicyResolver.apply(configuration), currentScheduler, this.transactionConfig, this.muleContext.getSecurityManager(), this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (!this.initialised) {
            this.initRetryPolicyResolver();
            try {
                this.transactionConfig = this.buildTransactionConfig();
            }
            catch (MuleException e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not resolve transactional configuration"), (Throwable)e, (Initialisable)this);
            }
            this.returnDelegate = this.createReturnDelegate();
            this.valueReturnDelegate = this.getValueReturnDelegate();
            LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, (Injector)this.muleContext.getInjector());
            this.componentExecutor = this.createComponentExecutor();
            this.executionMediator = this.createExecutionMediator();
            LifecycleUtils.initialiseIfNeeded((Object)this.componentExecutor, (MuleContext)this.muleContext);
            ComponentLocation componentLocation = this.getLocation();
            if (componentLocation != null) {
                this.processorPath = componentLocation.getLocation();
            }
            this.resolvedProcessorRepresentation = this.getRepresentation();
            if (this.nestedChain != null) {
                LOGGER.debug("Initializing nested chain ({}) of component '{}'...", (Object)this.nestedChain, (Object)this.processorPath);
                LifecycleUtils.initialiseIfNeeded((Object)this.nestedChain, (Injector)this.muleContext.getInjector());
            }
            this.initProcessingStrategy();
            this.operationParametersResolutionTracer = this.componentTracerFactory.fromComponent((Component)this, "mule:parameters-resolution", "");
            this.resolverSet = new TracedResolverSet(this.muleContext.getInjector(), (ComponentTracer<CoreEvent>)this.componentTracerFactory.fromComponent((Component)this, "mule:value-resolution", "")).addAll(this.resolverSet.getResolvers());
            this.initialised = true;
        }
    }

    private void initProcessingStrategy() throws InitialisationException {
        Optional processingStrategyFromRootContainer = MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.componentLocator, (Component)this);
        this.processingStrategy = processingStrategyFromRootContainer.orElseGet(() -> MessageProcessors.createDefaultProcessingStrategyFactory().create((ProfilingService)this.profilingService, this.featureFlaggingService, this.muleContext.getSchedulerService(), () -> ((MuleContext)this.muleContext).getSchedulerBaseConfig(), this.toString() + ".ps", this.muleConfiguration.getId(), ArtifactType.valueOf((String)this.muleConfiguration.getArtifactType().name()), () -> this.muleContext.getConfiguration().getShutdownTimeout()));
        if (processingStrategyFromRootContainer.isPresent()) {
            LOGGER.debug("Using processing strategy ({}) from container for component '{}'", (Object)this.processingStrategy, (Object)this.processorPath);
        } else {
            LOGGER.debug("Initializing own processing strategy ({}) of component '{}'...", (Object)this.processingStrategy, (Object)this.processorPath);
            this.ownedProcessingStrategy = true;
            LifecycleUtils.initialiseIfNeeded((Object)this.processingStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInnerFlux() {
        if (this.fluxSupplier == null) {
            Object object = this.fluxSupplierLock;
            synchronized (object) {
                this.startInnerFluxUnsafe();
            }
        }
    }

    private void startInnerFluxUnsafe() {
        if (this.fluxSupplier != null) {
            LOGGER.debug("Skipping creation of inner flux supplier for processor '{}' because it is already created.", (Object)this.getLocation());
            return;
        }
        LOGGER.debug("Starting fluxSupplier in component executor for {} at {}", (Object)this.getLocation().getLocation(), (Object)this.getLocation().getComponentIdentifier().getIdentifier());
        this.fluxSupplier = RxUtils.createRoundRobinFluxSupplier(p -> {
            ComponentInnerProcessor innerProcessor = new ComponentInnerProcessor(){

                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Flux.deferContextual(ctx -> {
                        FluxSinkRecorder emitter = new FluxSinkRecorder();
                        return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from((Publisher)publisher), (Publisher)emitter.flux(), pub -> Flux.from((Publisher)pub).doOnNext(this.innerEventDispatcher((FluxSinkRecorder<Either<EventProcessingException, CoreEvent>>)emitter)).map(e -> Either.empty()), () -> emitter.complete(), e -> emitter.error(e))).map(RxUtils.propagateErrorResponseMapper());
                    });
                }

                private Consumer<? super CoreEvent> innerEventDispatcher(FluxSinkRecorder<Either<EventProcessingException, CoreEvent>> emitter) {
                    return event -> ComponentMessageProcessor.this.prepareAndExecuteOperation((CoreEvent)event, () -> new CompletableComponentExecutor.ExecutorCallback(){
                        final /* synthetic */ FluxSinkRecorder val$emitter;
                        final /* synthetic */ CoreEvent val$event;
                        {
                            this.val$emitter = fluxSinkRecorder;
                            this.val$event = coreEvent;
                        }

                        public void complete(Object value) {
                            this.val$emitter.next((Object)Either.right((Object)((CoreEvent)value)));
                        }

                        public void error(Throwable e) {
                            this.val$emitter.next((Object)Either.left((Object)new EventProcessingException(this.val$event, e, false)));
                        }
                    });
                }

                public ReactiveProcessor.ProcessingType getProcessingType() {
                    return ComponentMessageProcessor.this.getInnerProcessingType();
                }

                public boolean isBlocking() {
                    return ComponentMessageProcessor.this.isBlocking();
                }

                public ComponentLocation resolveLocation() {
                    return ComponentMessageProcessor.this.getLocation();
                }
            };
            return Flux.from((Publisher)this.processingStrategy.configureInternalPublisher((Publisher)Flux.from((Publisher)p).transform((Function)this.processingStrategy.onProcessor((ReactiveProcessor)innerProcessor)).doOnNext(result -> this.getOperationExecutionParams((CoreEvent)result).callback().complete(result)).onErrorContinue((t, result) -> this.getOperationExecutionParams(((EventProcessingException)t).getEvent()).callback().error(t.getCause()))));
        }, (int)Runtime.getRuntime().availableProcessors());
    }

    protected SdkInternalContext.OperationExecutionParams getOperationExecutionParams(CoreEvent event) {
        try {
            return SdkInternalContext.from(event).getOperationExecutionParams(this.getLocation(), event.getContext().getId());
        }
        catch (NullPointerException npe) {
            LOGGER.debug("Null SDK Context at {} for event - {}", (Object)(this.getLocation() != null ? this.getLocation().getLocation() : "null"), (Object)event.getContext().getId());
            throw Exceptions.propagateWrappingFatal((Throwable)new EventProcessingException(I18nMessageFactory.createStaticMessage((String)("Maybe the non-blocking operation @ '" + this.getLocation().getLocation() + "' used its callback more than once?")), event, (Throwable)npe));
        }
    }

    private CoreEvent addContextToEvent(CoreEvent event, ContextView ctx) throws MuleException {
        SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
        if (sdkInternalContext == null) {
            sdkInternalContext = new SdkInternalContext();
            ((InternalEvent)event).setSdkInternalContext((EventInternalContext)sdkInternalContext);
        }
        ComponentLocation location = this.getLocation();
        String eventId = event.getContext().getId();
        sdkInternalContext.putContext(location, eventId);
        if (this.hasNestedChain && (ctx.hasKey((Object)"policy.nextOperation") || ctx.hasKey((Object)"policy.isPropagateMessageTransformations"))) {
            sdkInternalContext.setInnerChainSubscriberContextMapping(innerChainCtx -> {
                if (ctx.hasKey((Object)"policy.nextOperation")) {
                    innerChainCtx = innerChainCtx.put((Object)"policy.nextOperation", ctx.get((Object)"policy.nextOperation"));
                }
                if (ctx.hasKey((Object)"policy.isPropagateMessageTransformations")) {
                    innerChainCtx = innerChainCtx.put((Object)"policy.isPropagateMessageTransformations", ctx.get((Object)"policy.isPropagateMessageTransformations"));
                }
                return innerChainCtx;
            });
        }
        sdkInternalContext.setConfiguration(location, eventId, this.resolveConfiguration(event));
        Map<String, Object> resolutionResult = this.shouldUsePrecalculatedContext(event) ? this.getPrecalculatedContext(event).getParameters() : this.getResolutionResult(event, sdkInternalContext.getConfiguration(location, eventId));
        sdkInternalContext.setResolutionResult(location, eventId, resolutionResult);
        sdkInternalContext.setPolicyToApply(location, eventId, location != null ? this.policyManager.orElse(PolicyManager.NOOP_POLICY_MANAGER).createOperationPolicy((Component)this, event, () -> resolutionResult) : DefaultPolicyManager.noPolicyOperation());
        return event;
    }

    private void setOperationExecutionParams(ComponentLocation location, CoreEvent event, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, CoreEvent operationEvent, CompletableComponentExecutor.ExecutorCallback callback, ContextView ctx) {
        ExecutionContextAdapter<T> operationContext;
        SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
        Scheduler currentScheduler = ctx.getOrEmpty((Object)"mule.nb.processorScheduler").orElse(ImmediateScheduler.IMMEDIATE_SCHEDULER);
        if (this.shouldUsePrecalculatedContext(operationEvent)) {
            operationContext = this.getPrecalculatedContext(operationEvent);
            operationContext.setCurrentScheduler(currentScheduler);
            operationContext.changeEvent(event);
        } else {
            operationContext = this.createExecutionContext(configuration, parameters, operationEvent, currentScheduler);
        }
        sdkInternalContext.setOperationExecutionParams(location, event.getContext().getId(), configuration, parameters, operationEvent, callback, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndExecuteOperation(CoreEvent event, Supplier<CompletableComponentExecutor.ExecutorCallback> callbackSupplier) {
        SdkInternalContext.OperationExecutionParams oep = this.getOperationExecutionParams(event);
        ExecutionContextAdapter operationContext = oep.executionContextAdapter();
        PrivilegedEvent.setCurrentEvent((PrivilegedEvent)((PrivilegedEvent)event));
        boolean wasProcessorPathSet = this.setCurrentLocation();
        try {
            this.executeOperation(operationContext, this.mapped(callbackSupplier.get(), operationContext, this.isTargetWithPolicies(event) ? this.valueReturnDelegate : this.returnDelegate));
        }
        finally {
            this.unsetCurrentLocation(wasProcessorPathSet);
        }
    }

    private boolean setCurrentLocation() {
        if (MDC.get((String)PROCESSOR_PATH_MDC_KEY) != null) {
            return false;
        }
        if (this.processorPath == null) {
            return false;
        }
        MDC.put((String)PROCESSOR_PATH_MDC_KEY, (String)this.processorPath);
        return true;
    }

    private void unsetCurrentLocation(boolean wasProcessorPathSet) {
        if (wasProcessorPathSet) {
            MDC.remove((String)PROCESSOR_PATH_MDC_KEY);
        }
    }

    private void initRetryPolicyResolver() {
        Optional<ConfigurationInstance> staticConfig = this.getStaticConfiguration();
        RetryPolicyTemplateResolver policyResolver = this.getRetryPolicyTemplateResolver();
        if (staticConfig.isPresent() || !this.requiresConfig()) {
            RetryPolicyTemplate staticPolicy = policyResolver.fetchRetryPolicyTemplate(staticConfig);
            this.retryPolicyResolver = config -> staticPolicy;
        } else {
            this.retryPolicyResolver = policyResolver::fetchRetryPolicyTemplate;
        }
    }

    protected RetryPolicyTemplateResolver getRetryPolicyTemplateResolver() {
        return new ComponentRetryPolicyTemplateResolver(this.retryPolicyTemplate, this.connectionManager);
    }

    private CompletableComponentExecutor<T> createComponentExecutor() throws InitialisationException {
        Map<String, Object> params = CompletableOperationExecutorFactory.extractExecutorInitialisationParams(this.extensionModel, this.componentModel, this.resolverSet.getResolvers(), this, this.getStaticConfiguration(), this.extensionManager, this.expressionManager, this.reflectionCache);
        return MuleExtensionUtils.getOperationExecutorFactory(this.componentModel).createExecutor(this.componentModel, params);
    }

    protected ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid(this.componentModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? this.getValueReturnDelegate() : this.getTargetReturnDelegate();
    }

    protected ReturnDelegate getTargetReturnDelegate() {
        if (ExpressionLanguageUtils.isSanitizedPayload((String)org.mule.runtime.api.el.ExpressionLanguageUtils.sanitize((String)this.targetValue))) {
            return new PayloadTargetReturnDelegate(this.target, this.componentModel, this.artifactEncoding);
        }
        return new TargetReturnDelegate(this.target, this.targetValue, this.componentModel, this.expressionManager, this.artifactEncoding, this.streamingManager);
    }

    protected ValueReturnDelegate getValueReturnDelegate() {
        return new ValueReturnDelegate(this.componentModel, this.artifactEncoding);
    }

    protected boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.expressionManager.isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "an expression", "target"));
        }
        if (!this.expressionManager.isExpression(this.targetValue)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "something that is not an expression", "targetValue"));
        }
        return true;
    }

    protected boolean isBlocking() {
        return !this.mayCompleteInDifferentThread();
    }

    protected boolean mayCompleteInDifferentThread() {
        if (!this.requiresConfig()) {
            return false;
        }
        if (this.usesDynamicConfiguration()) {
            return true;
        }
        Optional<ConfigurationInstance> staticConfig = this.getStaticConfiguration();
        if (staticConfig.isPresent()) {
            return this.isAsyncExecutableBasedOn(staticConfig);
        }
        return true;
    }

    protected boolean isAsyncExecutableBasedOn(Optional<ConfigurationInstance> staticConfig) {
        return this.retryPolicyResolver.apply(staticConfig).isEnabled();
    }

    protected void startIfNeededNestedChain() throws MuleException {
        if (this.nestedChain != null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)currentClassLoader, (ClassLoader)this.nestedChainClassLoader);
            try {
                LOGGER.debug("Starting nested chain ({}) of component '{}'...", (Object)this.nestedChain, (Object)this.processorPath);
                LifecycleUtils.startIfNeeded((Object)this.nestedChain);
            }
            finally {
                ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)this.nestedChainClassLoader, (ClassLoader)currentClassLoader);
            }
        }
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentExecutor);
        this.startIfNeededNestedChain();
        LifecycleUtils.startIfNeeded(this.getRoutes());
        if (this.ownedProcessingStrategy) {
            LOGGER.debug("Starting own processing strategy ({}) of component '{}'...", (Object)this.processingStrategy, (Object)this.processorPath);
            LifecycleUtils.startIfNeeded((Object)this.processingStrategy);
        }
        if (this.outerFluxTerminationTimeout >= 0L) {
            this.outerFluxCompletionScheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(this.toString() + ".outer.flux."));
            LOGGER.debug("Created outerFluxCompletionScheduler ({}) of component '{}'", (Object)this.outerFluxCompletionScheduler, (Object)this.processorPath);
        }
        LOGGER.debug("Starting inner flux of component '{}'...", (Object)this.processorPath);
        this.startInnerFlux();
    }

    @Override
    public void doStop() throws MuleException {
        if (this.nestedChain != null) {
            LOGGER.debug("Sttopping nested chain ({}) of component '{}'...", (Object)this.nestedChain, (Object)this.processorPath);
            LifecycleUtils.stopIfNeeded((Object)this.nestedChain);
        }
        LifecycleUtils.stopIfNeeded(this.getRoutes());
        LifecycleUtils.stopIfNeeded((Object)this.componentExecutor);
        LOGGER.debug("Stopping inner flux of component '{}'...", (Object)this.processorPath);
        this.stopInnerFlux();
        if (this.ownedProcessingStrategy) {
            LOGGER.debug("Stopping own processing strategy ({}) of component '{}'...", (Object)this.processingStrategy, (Object)this.processorPath);
            LifecycleUtils.stopIfNeeded((Object)this.processingStrategy);
        }
        if (this.outerFluxTerminationTimeout >= 0L && this.outerFluxCompletionScheduler != null) {
            LOGGER.debug("Stopping outerFluxCompletionScheduler ({}) of component '{}'...", (Object)this.outerFluxCompletionScheduler, (Object)this.processorPath);
            this.outerFluxCompletionScheduler.stop();
            this.outerFluxCompletionScheduler = null;
        }
    }

    private Collection<RouteBuilderValueResolver> getRoutes() {
        return this.getRoutesRecursively(this.resolverSet.getResolvers().values()).toList();
    }

    private Stream<RouteBuilderValueResolver> getRoutesRecursively(Collection<ValueResolver<?>> resolverSetValues) {
        return resolverSetValues.stream().flatMap(resolver -> {
            if (resolver instanceof CollectionValueResolver) {
                CollectionValueResolver collectionValueResolver = (CollectionValueResolver)resolver;
                return this.getRoutesRecursively(collectionValueResolver.getResolvers());
            }
            if (resolver instanceof RouteBuilderValueResolver) {
                RouteBuilderValueResolver routeBuilderValueResolver = (RouteBuilderValueResolver)resolver;
                return Stream.of(routeBuilderValueResolver);
            }
            return Stream.empty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outerPublisherSubscribedTo() {
        AtomicInteger atomicInteger = this.activeOuterPublishersCount;
        synchronized (atomicInteger) {
            if (this.activeOuterPublishersCount.getAndIncrement() == 0) {
                this.startInnerFlux();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outerPublisherTerminated() {
        AtomicInteger atomicInteger = this.activeOuterPublishersCount;
        synchronized (atomicInteger) {
            if (this.activeOuterPublishersCount.decrementAndGet() == 0) {
                this.stopInnerFlux();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInnerFlux() {
        if (this.fluxSupplier != null) {
            Object object = this.fluxSupplierLock;
            synchronized (object) {
                if (this.fluxSupplier != null) {
                    this.fluxSupplier.dispose();
                    this.fluxSupplier = null;
                }
            }
        }
    }

    @Override
    public void doDispose() {
        if (this.nestedChain != null) {
            LOGGER.debug("Disposing nested chain ({}) of component '{}'...", (Object)this.nestedChain, (Object)this.processorPath);
            LifecycleUtils.disposeIfNeeded((Object)this.nestedChain, (Logger)LOGGER);
        }
        LifecycleUtils.disposeIfNeeded(this.getRoutes(), (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.componentExecutor, (Logger)LOGGER);
        if (this.ownedProcessingStrategy) {
            LOGGER.debug("Disposing own processing strategy ({}) of component '{}'...", (Object)this.ownedProcessingStrategy, (Object)this.processorPath);
            LifecycleUtils.disposeIfNeeded((Object)this.processingStrategy, (Logger)LOGGER);
        }
        this.initialised = false;
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator<ComponentModel>(this.extensionModel, this.componentModel, InterceptorChainUtils.createConnectionInterceptorsChain(this.extensionModel, this.componentModel, this.extensionConnectionSupplier, this.reflectionCache, (ComponentTracer<CoreEvent>)this.componentTracerFactory.fromComponent((Component)this, "mule:get-connection", "")), this.errorTypeRepository, this.muleContext.getExecutionClassLoader(), this.muleConfiguration, ArtifactType.valueOf((String)this.muleContext.getArtifactType().name()), this.notificationDispatcher, this.resultTransformer, (ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent>)this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE), (ComponentTracer<CoreEvent>)this.componentTracerFactory.fromComponent((Component)this, "mule:operation-execution", ""), this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.SUPPRESS_ERRORS));
    }

    @Override
    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    public ReactiveProcessor.ProcessingType getInnerProcessingType() {
        return ReactiveProcessor.ProcessingType.CPU_LITE;
    }

    public void resolveParameters(CoreEvent.Builder eventBuilder, BiConsumer<Map<String, Supplier<Object>>, ExecutionContext> afterConfigurer) throws MuleException {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        ExecutionContextAdapter<T> delegateExecutionContext = this.createExecutionContext(eventBuilder.build());
        PrecalculatedExecutionContextAdapter<T> executionContext = new PrecalculatedExecutionContextAdapter<T>(delegateExecutionContext);
        Throwable throwable = mediator.applyBeforeInterceptors(executionContext);
        if (throwable != null) {
            throw new DefaultMuleException("Interception execution for operation not ok", throwable);
        }
        Map<String, Object> resolvedArguments = this.getArgumentResolver().apply(executionContext);
        afterConfigurer.accept(resolvedArguments, executionContext);
        executionContext.changeEvent(eventBuilder.build());
    }

    private Function<ExecutionContext<T>, Map<String, Object>> getArgumentResolver() {
        if (this.componentExecutor instanceof OperationArgumentResolverFactory) {
            return ((OperationArgumentResolverFactory)this.componentExecutor).createArgumentResolver(this.componentModel);
        }
        return ec -> Collections.emptyMap();
    }

    public void disposeResolvedParameters(ExecutionContext<T> executionContext) {
        ((DefaultExecutionMediator)this.executionMediator).applyAfterInterceptors(executionContext);
    }

    private ExecutionContextAdapter<T> createExecutionContext(CoreEvent event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event, ImmediateScheduler.IMMEDIATE_SCHEDULER);
    }

    private Map<String, Object> getResolutionResult(CoreEvent event, Optional<ConfigurationInstance> configuration) throws MuleException {
        this.operationParametersResolutionTracer.startSpan((Event)event);
        try {
            ValueResolvingContext context = ValueResolvingContext.builder(event, this.expressionManager).withConfig(configuration).withLocation(this.getLocation()).build();
            try {
                Map<String, Object> map = this.resolverSet.resolve(context).asMap();
                if (context != null) {
                    context.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.operationParametersResolutionTracer.endCurrentSpan((Event)event);
        }
    }

    private boolean isInterceptedComponent(ComponentLocation location, InternalEvent event) {
        Component component = (Component)event.getInternalParameter("core:interceptionComponent");
        if (component != null) {
            return location.equals(component.getLocation());
        }
        return false;
    }

    private boolean supportsTransactions(T componentModel) {
        return componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)componentModel).isTransactional();
    }

    private boolean requiresTransactionalActionConfiguration(T componentModel) {
        return !ComponentDeclarationUtils.isNoTransactionalAction(componentModel);
    }

    private boolean hasNestedChain(T componentModel) {
        return componentModel.getNestedComponents().stream().anyMatch(nestedComp -> nestedComp instanceof NestedRouteModel || ((NestedComponentModel)nestedComp).getAllowedStereotypes().stream().anyMatch(st -> st.isAssignableTo(MuleStereotypes.PROCESSOR)));
    }

    private Optional<TransactionConfig> buildTransactionConfig() throws MuleException {
        if (!this.supportsTransactions(this.componentModel) || !this.requiresTransactionalActionConfiguration(this.componentModel)) {
            return Optional.empty();
        }
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        transactionConfig.setFactory((TransactionFactory)TRANSACTION_FACTORY);
        return Optional.of(transactionConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationTransactionalAction getTransactionalAction() throws MuleException {
        ValueResolver<?> resolver = this.resolverSet.getResolvers().get("transactionalAction");
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Operation '%s' from extension '%s' is transactional but no transactional action defined", this.componentModel.getName(), this.extensionModel.getName()));
        }
        CoreEvent initializerEvent = NullEventFactory.getNullEvent();
        try {
            OperationTransactionalAction operationTransactionalAction = SdkOperationTransactionalActionUtils.from(resolver.resolve(ValueResolvingContext.builder(initializerEvent).build()));
            return operationTransactionalAction;
        }
        finally {
            ((BaseEventContext)initializerEvent.getContext()).success();
        }
    }

    public String toString() {
        ComponentLocation location = this.getLocation();
        return location != null ? location.getLocation() : super.toString();
    }

    @Inject
    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.muleConfiguration = muleConfiguration;
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        CoreEvent event = NullEventFactory.getNullEvent();
        try {
            ValueResolvingContext ctx = ValueResolvingContext.builder(event, this.expressionManager).build();
            try {
                LazyExecutionContext<ComponentModel> executionContext = new LazyExecutionContext<ComponentModel>(this.resolverSet, this.componentModel, this.extensionModel, ctx);
                OperationParameterValueResolver<ComponentModel> operationParameterValueResolver = new OperationParameterValueResolver<ComponentModel>(executionContext, this.resolverSet, this.reflectionCache, this.expressionManager);
                if (ctx != null) {
                    ctx.close();
                }
                return operationParameterValueResolver;
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            ((BaseEventContext)event.getContext()).success();
        }
    }
}

