/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.util;

import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.server.RequestEntityTooLargeHandler;
import org.mule.service.http.netty.impl.server.util.BadRequestHandler;
import org.mule.service.http.netty.impl.server.util.DefaultRequestHandlerManager;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.service.http.netty.impl.server.util.HeaderTooLongRequestHandler;
import org.mule.service.http.netty.impl.server.util.NoListenerRequestHandler;
import org.mule.service.http.netty.impl.server.util.NoMethodRequestHandler;
import org.mule.service.http.netty.impl.server.util.RequestHandlerProvider;
import org.mule.service.http.netty.impl.server.util.ServerAddressMap;
import org.mule.service.http.netty.impl.server.util.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerRegistry
implements RequestHandlerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerRegistry.class);
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_SERVER_REQUEST_HEADERS_KEY = "mule.http.MAX_SERVER_REQUEST_HEADERS";
    private static int MAX_SERVER_REQUEST_HEADERS = Integer.getInteger("mule.http.MAX_SERVER_REQUEST_HEADERS", 100);
    private final ServerAddressMap<HttpServer> serverAddressToServerMap = new ServerAddressMap();
    private final Map<HttpServer, RequestMatcherRegistry<RequestHandler>> requestHandlerPerServerAddress = new HashMap<HttpServer, RequestMatcherRegistry<RequestHandler>>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandlerManager addRequestHandler(HttpServer server, RequestHandler requestHandler, PathAndMethodRequestMatcher requestMatcher) {
        this.writeLock.lock();
        try {
            RequestMatcherRegistry serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server);
            if (serverAddressRequestHandlerRegistry == null) {
                serverAddressRequestHandlerRegistry = new DefaultRequestMatcherRegistryBuilder<RequestHandler>().onMethodMismatch(NoMethodRequestHandler::getInstance).onNotFound(NoListenerRequestHandler::getInstance).onInvalidRequest(BadRequestHandler::getInstance).onDisabled(ServiceTemporarilyUnavailableListenerRequestHandler::getInstance).build();
                this.requestHandlerPerServerAddress.put(server, (RequestMatcherRegistry<RequestHandler>)serverAddressRequestHandlerRegistry);
                this.serverAddressToServerMap.put(server.getServerAddress(), server);
            }
            DefaultRequestHandlerManager defaultRequestHandlerManager = new DefaultRequestHandlerManager(serverAddressRequestHandlerRegistry.add(requestMatcher, (Object)requestHandler));
            return defaultRequestHandlerManager;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeHandlersFor(HttpServer server) {
        this.writeLock.lock();
        try {
            this.requestHandlerPerServerAddress.remove(server);
            this.serverAddressToServerMap.remove(server.getServerAddress());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasHandlerFor(ServerAddress serverAddress) {
        this.readLock.lock();
        try {
            boolean bl = this.serverAddressToServerMap.get(serverAddress) != null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestHandler getRequestHandler(ServerAddress serverAddress, HttpRequest request) {
        LOGGER.debug("Looking RequestHandler for request: {}", (Object)request.getPath());
        if (!HttpListenerRegistry.checkMaxRequestHeadersLimit((Map<String, String>)request.getHeaders())) {
            return RequestEntityTooLargeHandler.getInstance();
        }
        this.readLock.lock();
        try {
            RequestMatcherRegistry<RequestHandler> serverAddressRequestHandlerRegistry;
            HttpServer server = this.serverAddressToServerMap.get(serverAddress);
            if (server != null && !server.isStopped() && (serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server)) != null) {
                RequestHandler requestHandler = (RequestHandler)serverAddressRequestHandlerRegistry.find(request);
                return requestHandler;
            }
            LOGGER.debug("No RequestHandler found for request: {}", (Object)request.getPath());
            NoListenerRequestHandler noListenerRequestHandler = NoListenerRequestHandler.getInstance();
            return noListenerRequestHandler;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static boolean checkMaxRequestHeadersLimit(Map<String, String> headers) {
        if (headers.size() > MAX_SERVER_REQUEST_HEADERS) {
            LOGGER.warn("Exceeded max server request headers limit: {}. Current header count (including default headers): {}", (Object)MAX_SERVER_REQUEST_HEADERS, (Object)headers.size());
            return false;
        }
        return true;
    }

    public static void refreshMaxServerRequestHeaders() {
        MAX_SERVER_REQUEST_HEADERS = Integer.getInteger(MAX_SERVER_REQUEST_HEADERS_KEY, 100);
    }

    public static int getMaxServerRequestHeaders() {
        return MAX_SERVER_REQUEST_HEADERS;
    }

    @Override
    public RequestHandler getErrorHandler(Throwable errorCause) {
        if (errorCause instanceof TooLongHttpLineException) {
            return HeaderTooLongRequestHandler.getInstance();
        }
        if (errorCause instanceof TooLongFrameException) {
            return RequestEntityTooLargeHandler.getInstance();
        }
        return null;
    }

    public RequestHandler getBadRequestHandler() {
        return BadRequestHandler.getInstance();
    }
}

