/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.DisplayName;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.test.common.client.HttpClientPostStreamingTestCase;
import org.mule.tck.util.FileUtils;

@DisplayName(value="Validates request streaming with a large payload")
@Issue(value="W-14543363")
public class RequestStreamingLargePayloadTestCase
extends HttpClientPostStreamingTestCase {
    public RequestStreamingLargePayloadTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected InputStream getInputStream() {
        try {
            return Files.newInputStream(FileUtils.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).toPath().resolve("largePayload"), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Error on loading the large payload file: " + e.toString()));
        }
    }

    @Override
    public HttpRequest getRequest() {
        return ((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)new InputStreamHttpEntity(this.getInputStream()))).build();
    }

    @Override
    public HttpRequestOptions getOptions() {
        return HttpRequestOptions.builder().responseTimeout(3000).build();
    }

    @Override
    public HttpResponse doSetUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        this.extractPayload(request);
        response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        return response.build();
    }

    @Override
    protected String expectedPayload() {
        try {
            return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/largePayload"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Error on loading the large payload file: " + e.toString()));
        }
    }
}

