/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.routing.UntilSuccessfulRouter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;

public class UntilSuccessful
extends AbstractMuleObjectOwner
implements Scope {
    private static final String DEFAULT_MILLIS_BETWEEN_RETRIES = "60000";
    private static final String DEFAULT_RETRIES = "5";
    public static final String UNTIL_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFIX = ":attempt";
    @Inject
    private MuleConfiguration muleConfiguration;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private Provider<SchedulerConfig> schedulerBaseConfig;
    @Inject
    private InternalProfilingService internalProfilingService;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    private String maxRetries = "5";
    private String millisBetweenRetries = "60000";
    private MessageProcessorChain nestedChain;
    private boolean suppressErrors;
    private boolean retryOnCriticalErrors;
    private boolean cancelOnForcefulShutdown;
    private Predicate<CoreEvent> shouldRetry;
    private Scheduler timer;
    private List<Processor> processors;
    private boolean ownProcessingStrategy;
    private ProcessingStrategy processingStrategy;

    public void initialise() throws InitialisationException {
        if (this.processors == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"One message processor must be configured within 'until-successful'."), (Initialisable)this);
        }
        Optional processingStrategyFromRootContainer = MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this);
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors((Optional)processingStrategyFromRootContainer, this.processors, null, (String)this.getLocation().getLocation(), (ComponentTracer)this.componentTracerFactory.fromComponent((Component)this, UNTIL_SUCCESSFUL_ATTEMPT_SPAN_NAME_SUFIX));
        super.initialise();
        this.timer = this.schedulerService.cpuLightScheduler(SchedulerConfig.config().withName(((Object)((Object)this)).getClass().getName() + ".timer - " + this.getLocation().getLocation()));
        this.suppressErrors = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.SUPPRESS_ERRORS);
        this.retryOnCriticalErrors = !this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.DISALLOW_UNTIL_SUCCESSFUL_RETRIES_ON_CRITICAL_ERRORS);
        this.cancelOnForcefulShutdown = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.RAISE_CANCELLED_ERROR_ON_FORCEFUL_SHUTDOWN);
        this.shouldRetry = event -> event.getError().isPresent();
        this.ownProcessingStrategy = processingStrategyFromRootContainer.isEmpty();
        this.processingStrategy = processingStrategyFromRootContainer.orElseGet(() -> MessageProcessors.createDefaultProcessingStrategyFactory().create((ProfilingService)this.internalProfilingService, this.featureFlaggingService, this.schedulerService, () -> (SchedulerConfig)this.schedulerBaseConfig.get(), this.getLocation().getLocation() + ".ps", this.muleConfiguration.getId(), ArtifactType.valueOf((String)this.muleConfiguration.getArtifactType().name()), () -> this.muleConfiguration.getShutdownTimeout()));
    }

    public void stop() throws MuleException {
        if (this.ownProcessingStrategy) {
            LifecycleUtils.stopIfNeeded((Object)this.processingStrategy);
        }
        super.stop();
    }

    public void dispose() {
        if (this.ownProcessingStrategy) {
            LifecycleUtils.disposeIfNeeded((Object)this.processingStrategy, (Logger)this.logger);
        }
        super.dispose();
        this.timer.stop();
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        try {
            return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
        }
        catch (Exception error) {
            Throwable cause = error.getCause();
            if (cause != null && cause instanceof UntilSuccessfulRouter.RetryContextInitializationException && cause.getCause() instanceof ExpressionRuntimeException) {
                throw (ExpressionRuntimeException)cause.getCause();
            }
            throw error;
        }
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return new UntilSuccessfulRouter((Component)this, publisher, (Processor)this.nestedChain, this.processingStrategy, this.expressionManager, this.shouldRetry, this.timer, this.maxRetries, this.millisBetweenRetries, this.suppressErrors, this.retryOnCriticalErrors, this.cancelOnForcefulShutdown).getDownstreamPublisher();
    }

    public String getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(String maxRetries) {
        this.maxRetries = maxRetries;
    }

    public String getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(String millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Object> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }
}

