/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public final class TestUtils {
    private TestUtils() {
    }

    public static void preservingHeaderCase(Runnable runnable) {
        System.setProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE", "true");
        HttpServerProperties.refreshSystemProperties();
        try {
            runnable.run();
        }
        finally {
            System.clearProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE");
            HttpServerProperties.refreshSystemProperties();
        }
    }

    public static String sendRawRequestToServer(String rawRequestToSend, String host, int port) throws IOException {
        try (Socket clientSocket = new Socket(host, port);){
            clientSocket.getOutputStream().write(rawRequestToSend.getBytes());
            byte[] responseBuffer = new byte[1024];
            clientSocket.getInputStream().read(responseBuffer);
            String string = new String(responseBuffer);
            return string;
        }
    }

    public static SslContext createServerSslContext() throws Exception {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().enabledCipherSuites("TLS_SOMETHING").enabledProtocols("TLSv1.1").keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").trustStorePath("trustStore").trustStorePassword("mulepassword").trustStoreType("jceks").insecureTrustStore(true).build();
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), ClientAuth.NONE, null, false);
    }

    public static long measuringNanoseconds(ThrowingRunnable runnable) {
        long nanosBefore = System.nanoTime();
        try {
            runnable.run();
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected exception: " + String.valueOf(t)));
        }
        long nanosAfter = System.nanoTime();
        return nanosAfter - nanosBefore;
    }

    public static void tryReportLeaks() {
        if (ResourceLeakDetector.Level.PARANOID.equals((Object)ResourceLeakDetector.getLevel())) {
            TestUtils.ensureGarbageIsCollected();
            ByteBufAllocator.DEFAULT.buffer().release();
        }
    }

    public static SslContext createSslContext(TlsContextFactory tlsContextFactory) throws NoSuchAlgorithmException, KeyManagementException {
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), ClientAuth.NONE, null, false);
    }

    private static void ensureGarbageIsCollected() {
        ReferenceQueue queue = new ReferenceQueue();
        PhantomReference<Object> ref = new PhantomReference<Object>(new Object(), queue);
        new PollingProber(10000L, 100L).poll((Probe)new JUnitLambdaProbe(() -> {
            System.gc();
            return queue.poll() != null;
        }));
    }
}

