/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.NestedRouteModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.route.JavaChainParsingUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.route.ExecutionOccurrence;
import org.mule.sdk.api.runtime.route.Route;

public class JavaNestedRouteModelParser
implements NestedRouteModelParser {
    private final ExtensionParameter route;
    private final ExtensionLoadingContext loadingContext;
    private final List<ModelProperty> additionalModelProperties = new LinkedList<ModelProperty>();
    private final boolean listOfRoutes;
    private final boolean sdkApiDefined;

    public JavaNestedRouteModelParser(ExtensionParameter route, ExtensionLoadingContext loadingContext) {
        this.route = route;
        this.loadingContext = loadingContext;
        Class clazz = route.getType().getDeclaringClass().orElse(null);
        if (clazz != null) {
            if (clazz.isAssignableFrom(List.class)) {
                this.listOfRoutes = true;
                Class routeClazz = route.getType().getGenerics().get(0).getConcreteType().getDeclaringClass().orElse(null);
                this.additionalModelProperties.add(new ImplementingTypeModelProperty(routeClazz));
                this.sdkApiDefined = Route.class.isAssignableFrom(routeClazz);
            } else {
                this.listOfRoutes = false;
                this.additionalModelProperties.add(new ImplementingTypeModelProperty(clazz));
                this.sdkApiDefined = Route.class.isAssignableFrom(clazz);
            }
        } else {
            this.listOfRoutes = false;
            this.sdkApiDefined = false;
        }
    }

    public String getName() {
        return this.route.getAlias();
    }

    public String getDescription() {
        return this.route.getDescription();
    }

    public int getMinOccurs() {
        if (this.listOfRoutes) {
            return 0;
        }
        return this.route.isRequired() ? 1 : 0;
    }

    public Optional<Integer> getMaxOccurs() {
        return this.listOfRoutes ? Optional.empty() : Optional.of(1);
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        Type routeType = this.listOfRoutes ? this.route.getType().getGenerics().get(0).getConcreteType() : this.route.getType();
        List<FieldElement> parameters = routeType.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class, Parameter.class);
        return JavaExtensionModelParserUtils.getParameterGroupParsers(parameters, ParameterDeclarationContext.forRoute(this.getName(), this.loadingContext));
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return this.additionalModelProperties;
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.route);
    }

    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.getAllowedStereotypes(this.route, this.route.getType(), factory);
    }

    public ChainExecutionOccurrence getExecutionOccurrence() {
        return JavaChainParsingUtils.parseChainExecutionOccurrence(this.route.getValueFromAnnotation(ExecutionOccurrence.class));
    }

    public Set<String> getSemanticTerms() {
        return new LinkedHashSet<String>();
    }

    public boolean isSdkApiDefined() {
        return this.sdkApiDefined;
    }
}

