/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.io.IOException;
import java.util.Objects;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.Preconditions;

public abstract class AbstractCursorIterator<T>
implements CursorIterator<T> {
    private final CursorIteratorProvider provider;
    private boolean released = false;
    private boolean closed = false;
    private long position = 0L;

    public AbstractCursorIterator(CursorIteratorProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.provider = provider;
    }

    protected abstract T doNext(long var1);

    public final T next() {
        this.assertNotClosed();
        T item = this.doNext(this.position);
        ++this.position;
        return item;
    }

    public long getPosition() {
        return this.position;
    }

    public void seek(long position) throws IOException {
        this.assertNotClosed();
        this.position = position;
    }

    public final void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.doClose();
        }
    }

    protected abstract void doClose() throws IOException;

    public boolean isReleased() {
        return this.released;
    }

    public CursorIteratorProvider getProvider() {
        return this.provider;
    }

    protected void assertNotClosed() {
        Preconditions.checkState((!this.released ? 1 : 0) != 0, (String)"Stream is closed");
    }

    public void remove() {
        throw new UnsupportedOperationException("Removing from a stream is not supported");
    }
}

