/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.BackPressureModeParser;
import org.mule.runtime.extension.api.loader.parser.MediaTypeParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.SourceModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.source.SdkSourceFactory;
import org.mule.runtime.extension.privileged.semantic.SemanticTermsHelper;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaExecutableComponentModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaBackPressureModeParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.source.JavaSdkSourceFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataKeyIdModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaOutputResolverModelParserUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.source.ClusterSupport;
import org.mule.sdk.api.runtime.source.PollingSource;

public class JavaSourceModelParser
extends AbstractJavaExecutableComponentModelParser
implements SourceModelParser {
    private final SourceElement sourceElement;
    private final Class<?> sourceClass;
    private final Optional<ExtensionParameter> configParameter;
    private final Optional<ExtensionParameter> connectionParameter;

    public JavaSourceModelParser(ExtensionElement extensionElement, SourceElement sourceElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.sourceElement = sourceElement;
        this.sourceClass = sourceElement.getDeclaringClass().orElse(null);
        this.configParameter = JavaExtensionModelParserUtils.getConfigParameter(sourceElement);
        this.connectionParameter = JavaExtensionModelParserUtils.getConnectionParameter(sourceElement);
        if (!this.isIgnored()) {
            this.parseStructure();
            this.collectAdditionalModelProperties();
        }
    }

    @Override
    public String getName() {
        return this.sourceElement.getAlias();
    }

    public String getDescription() {
        return this.sourceElement.getDescription();
    }

    public boolean emitsResponse() {
        return JavaModelLoaderUtils.emitsResponse(this.sourceElement);
    }

    public Optional<SdkSourceFactory> getSourceFactory() {
        if (this.sourceClass == null) {
            return Optional.empty();
        }
        return Optional.of(new JavaSdkSourceFactory(this.sourceClass));
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return JavaExtensionModelParserUtils.getSourceParameterGroupParsers(this.sourceElement.getParameters(), ParameterDeclarationContext.forSource(this.getName(), this.loadingContext, this.hasKeyResolverAvailable()));
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnSuccessCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnResponseMethod());
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnErrorCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnErrorMethod());
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnTerminateCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnTerminateMethod());
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnBackPressureCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnBackPressureMethod());
    }

    public boolean isIgnored() {
        return IntrospectionUtils.isIgnored(this.sourceElement, this.loadingContext);
    }

    public Optional<MediaTypeParser> getMediaType() {
        return JavaExtensionModelParserUtils.getMediaType(this.sourceElement, "Source", this.getName());
    }

    public Optional<SdkExceptionHandlerFactory> getExceptionHandlerFactory() {
        return JavaErrorModelParserUtils.getExceptionHandlerFactory(this.sourceElement, "Source", this.getName());
    }

    public boolean hasConfig() {
        return this.configParameter.isPresent();
    }

    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getAllTermsFromAnnotations(this.sourceElement::isAnnotatedWith));
        SemanticTermsParserUtils.addCustomTerms(this.sourceElement, terms);
        return terms;
    }

    private void collectAdditionalModelProperties() {
        this.additionalModelProperties.add(new ExtensionTypeDescriptorModelProperty(this.sourceElement));
        if (this.sourceClass != null) {
            this.additionalModelProperties.add(new ImplementingTypeModelProperty(this.sourceClass));
        }
        this.additionalModelProperties.add(new SourceCallbackModelProperty(this.extractJavaMethod(this.sourceElement.getOnResponseMethod()), this.extractJavaMethod(this.sourceElement.getOnErrorMethod()), this.extractJavaMethod(this.sourceElement.getOnTerminateMethod()), this.extractJavaMethod(this.sourceElement.getOnBackPressureMethod())));
    }

    private Optional<Method> extractJavaMethod(Optional<MethodElement> method) {
        return method.flatMap(MethodElement::getMethod);
    }

    public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
        List<String> identifiers = NotificationModelParserUtils.getEmittedNotifications(this.sourceElement, this.getComponentTypeName(), this.getName());
        return identifiers.stream().map(notificationMapper).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    protected String getComponentTypeName() {
        return "Source";
    }

    private void parseStructure() {
        this.validateLifecycle(this.sourceElement, Startable.class);
        this.validateLifecycle(this.sourceElement, Stoppable.class);
        List<Type> sourceGenerics = this.sourceElement.getSuperClassGenerics();
        if (sourceGenerics.size() != 2) {
            throw new IllegalModelDefinitionException(String.format("Message source class '%s' was expected to have 2 generic types (one for the Payload type and another for the Attributes type) but %d were found", this.getName(), sourceGenerics.size()));
        }
        this.resolveOutputTypes();
        this.parseComponentByteStreaming(this.sourceElement);
        this.connected = this.connectionParameter.isPresent();
        this.parseComponentConnectivity(this.sourceElement);
    }

    private void resolveOutputTypes() {
        Optional<OutputResolverModelParser> outputResolverModelParser = JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(this.extensionElement, this.sourceElement);
        boolean isDynamicResolver = outputResolverModelParser.isPresent() && outputResolverModelParser.get().hasOutputResolver();
        this.outputType = new DefaultOutputModelParser(CustomStaticTypeUtils.getSourceOutputType(this.sourceElement), isDynamicResolver);
        Optional<AttributesResolverModelParser> attributesResolverModelParser = JavaOutputResolverModelParserUtils.parseAttributesResolverModelParser(this.extensionElement, this.sourceElement);
        isDynamicResolver = attributesResolverModelParser.isPresent() && attributesResolverModelParser.get().hasAttributesResolver();
        this.outputAttributesType = new DefaultOutputModelParser(CustomStaticTypeUtils.getSourceAttributesType(this.sourceElement), isDynamicResolver);
    }

    private void validateLifecycle(SourceElement sourceType, Class<?> lifecycleType) {
        if (sourceType.isAssignableTo(lifecycleType)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source class '%s' implements lifecycle interface '%s'. Sources are only not allowed to implement '%s' and '%s'", sourceType.getName(), lifecycleType, Initialisable.class.getSimpleName(), Disposable.class.getSimpleName()));
        }
    }

    private Optional<SourceModelParser.SourceCallbackModelParser> parseSourceCallback(Optional<MethodElement> methodElement) {
        return methodElement.map(method -> new JavaSourceCallbackModelParser((MethodElement<?>)method, JavaExtensionModelParserUtils.getParameterGroupParsers(method.getParameters(), ParameterDeclarationContext.forSource(this.getName(), this.loadingContext))));
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.sourceElement);
    }

    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.sourceElement, "source", this.sourceElement.getName());
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.resolveStereotype(this.sourceElement, "Source", this.getName(), factory);
    }

    public Optional<BackPressureModeParser> getBackPressureModeParser() {
        return JavaBackPressureModeParser.fromBackPressureAnnotation(this.sourceElement).map(Function.identity());
    }

    public Optional<SourceClusterSupport> getSourceClusterSupport() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.sourceElement, "source", this.sourceElement.getName(), org.mule.runtime.extension.api.annotation.source.ClusterSupport.class, ClusterSupport.class, legacyAnnotation -> legacyAnnotation.getEnumValue(org.mule.runtime.extension.api.annotation.source.ClusterSupport::value), sdkAnnotation -> this.fromSdkApiSourceClusterSupport(sdkAnnotation.getEnumValue(ClusterSupport::value)));
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.of(MinMuleVersionUtils.resolveSourceMinMuleVersion(this.sourceElement));
    }

    public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
        return JavaOutputResolverModelParserUtils.parseOutputResolverModelParser(this.extensionElement, this.sourceElement);
    }

    public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
        return JavaOutputResolverModelParserUtils.parseAttributesResolverModelParser(this.extensionElement, this.sourceElement);
    }

    public Optional<MetadataKeyModelParser> getMetadataKeyModelParser() {
        return JavaMetadataKeyIdModelParserUtils.getKeyIdResolverModelParser(this, (WithAnnotations)this.sourceElement, this.extensionElement);
    }

    public boolean isPolling() {
        return this.sourceElement.isAssignableTo(org.mule.runtime.extension.api.runtime.source.PollingSource.class) || this.sourceElement.isAssignableTo(PollingSource.class);
    }

    public ComponentVisibility getComponentVisibility() {
        return ComponentVisibility.PUBLIC;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaSourceModelParser) {
            return this.sourceElement.equals(((JavaSourceModelParser)o).sourceElement);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sourceElement);
    }

    private boolean hasKeyResolverAvailable() {
        return JavaMetadataKeyIdModelParserUtils.parseKeyIdResolverModelParser(this.extensionElement, this.sourceElement, "source", this.getName(), this.extensionElement.getName()).map(metadataKey -> metadataKey.hasKeyIdResolver()).orElse(false);
    }

    private SourceClusterSupport fromSdkApiSourceClusterSupport(org.mule.sdk.api.annotation.source.SourceClusterSupport sourceClusterSupport) {
        return switch (sourceClusterSupport) {
            case org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY -> SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY;
            case org.mule.sdk.api.annotation.source.SourceClusterSupport.DEFAULT_ALL_NODES -> SourceClusterSupport.DEFAULT_ALL_NODES;
            default -> SourceClusterSupport.NOT_SUPPORTED;
        };
    }

    private static class JavaSourceCallbackModelParser
    implements SourceModelParser.SourceCallbackModelParser {
        private final List<ParameterGroupModelParser> groupModelParsers;

        public JavaSourceCallbackModelParser(MethodElement<?> methodElement, List<ParameterGroupModelParser> groupModelParsers) {
            this.groupModelParsers = groupModelParsers;
        }

        public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
            return this.groupModelParsers;
        }

        public List<InputResolverModelParser> getInputResolverModelParsers() {
            return this.groupModelParsers.stream().map(ParameterGroupModelParser::getParameterParsers).flatMap(Collection::stream).collect(Collectors.toList()).stream().map(ParameterModelParser::getInputResolverModelParser).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
    }
}

