/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.sse;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.runtime.http.api.sse.client.SseSource;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.util.HttpEntityMatcher;
import org.mule.service.http.test.common.util.HttpMessageHeaderMatcher;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.sse.SSEEventsAggregator;
import org.mule.service.http.test.netty.utils.sse.ServerSentEventTypeSafeMatcher;
import org.mule.tck.junit5.DynamicPort;

@Story(value="Streamable HTTP")
@Issue(value="W-18238331")
public class StreamableHttpTestCase
extends AbstractHttpServiceTestCase {
    private static final String TEST_DATA_EVENT_1 = "{'method': 'blah'}";
    private static final String TEST_DATA_EVENT_2 = "{'method': 'bleh'}";
    private static final String TEST_JSON = "{'method': 'blih'}";
    public static final String DEFAULT_EVENT_TYPE = "message";
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private HttpServer httpServer;
    private HttpClient httpClient;

    public StreamableHttpTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpServer = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setName("Streamable HTTP Server").setHost("localhost").setPort(this.serverPort.intValue()).build());
        this.httpServer.start();
        this.httpServer.addRequestHandler("/streamable-http", (ctx, callback) -> {
            block9: {
                try {
                    if (this.shouldRespondWithSSE(ctx.getRequest())) {
                        SseClientConfig clientConfig = SseClientConfig.builderFrom((HttpRequestContext)ctx).withClientId("my-client-id").customizeResponse(customizer -> customizer.addResponseHeader("X-My-Custom-Header", "TheValue")).build();
                        try (SseClient sseClient = callback.startSseResponse(clientConfig);){
                            sseClient.sendEvent(TEST_DATA_EVENT_1);
                            sseClient.sendEvent(TEST_DATA_EVENT_2);
                            break block9;
                        }
                    }
                    HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().addHeader("Content-Type", "application/json")).entity((HttpEntity)new StringHttpEntity(TEST_JSON))).build();
                    callback.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.httpClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("Streamable HTTP Client").setStreaming(true).build());
        this.httpClient.start();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        this.httpServer.stop().dispose();
    }

    @Test
    void streamableHttpReturnsSSE() throws ExecutionException, InterruptedException {
        this.streamableHttpTest("SSE");
    }

    @Test
    void streamableHttpReturnsJson() throws ExecutionException, InterruptedException {
        this.streamableHttpTest("JSON");
    }

    private void streamableHttpTest(String testExpectedContentType) throws InterruptedException, ExecutionException {
        block9: {
            SSEEventsAggregator listener = new SSEEventsAggregator();
            String sseUri = "http://localhost:" + this.serverPort + "/streamable-http";
            HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(sseUri).addHeader("Accept", "application/json, text/event-stream")).addHeader("X-SubProtocol", testExpectedContentType)).build();
            CompletableFuture future = this.httpClient.sendAsync(request);
            HttpResponse response = (HttpResponse)future.get();
            if (StreamableHttpTestCase.isSse(response)) {
                MatcherAssert.assertThat((Object)response, HttpMessageHeaderMatcher.hasHeader("X-My-Custom-Header", "TheValue"));
                try (SseSource sseSource = this.httpClient.sseSource(SseSourceConfig.fromResponse((HttpResponse)response).build());){
                    sseSource.register((SseListener)listener);
                    sseSource.open();
                    List<ServerSentEvent> eventsList = listener.getList();
                    MatcherAssert.assertThat(eventsList, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent(DEFAULT_EVENT_TYPE, TEST_DATA_EVENT_1), ServerSentEventTypeSafeMatcher.aServerSentEvent(DEFAULT_EVENT_TYPE, TEST_DATA_EVENT_2)}));
                    break block9;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            MatcherAssert.assertThat((Object)response.getEntity(), HttpEntityMatcher.hasContent((Matcher<String>)Matchers.equalTo((Object)TEST_JSON)));
        }
    }

    private static boolean isSse(HttpResponse response) {
        return response.getHeaderValue("Content-Type").equals("text/event-stream");
    }

    private boolean shouldRespondWithSSE(HttpRequest request) {
        String expectedSubprotocol = request.getHeaderValue("X-SubProtocol");
        return "SSE".equalsIgnoreCase(expectedSubprotocol);
    }
}

