/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.tck;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.rules.ExternalResource;

public class ExecutorRule
extends ExternalResource {
    private TestScheduledThreadPoolExecutor executor;

    protected void before() throws Throwable {
        this.executor = new TestScheduledThreadPoolExecutor(8);
    }

    protected void after() {
        this.executor.shutdownNow();
    }

    public void setRejectNext() {
        this.executor.setRejectNext(true);
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    private static class TestScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private final AtomicBoolean rejectNext = new AtomicBoolean(false);

        public TestScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        public void execute(Runnable command) {
            if (this.rejectNext.compareAndSet(true, false)) {
                throw new RejectedExecutionException();
            }
            super.execute(command);
        }

        public void setRejectNext(boolean rejectNext) {
            this.rejectNext.set(rejectNext);
        }
    }
}

