/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.client.sse;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.common.client.sse.ServerSentEventDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEventDataListener
implements ProgressiveBodyDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSentEventDataListener.class);
    private final CompletableFuture<InputStream> inputStreamFuture = new CompletableFuture();
    private final ServerSentEventDecoder decoder;

    public ServerSentEventDataListener(SseListener eventListener, String clientName) {
        this.decoder = new ServerSentEventDecoder(eventListener);
        LOGGER.trace("Creating SSE Data listener with decoder id '{}' associated to client named '{}'", (Object)this.decoder.getId(), (Object)clientName);
    }

    @Override
    public void onStreamCreated(InputStream inputStream) {
        if (this.inputStreamFuture.isDone()) {
            throw new IllegalStateException("Another input stream was already added to the event decoder");
        }
        LOGGER.trace("SSE Listener ({}): Event stream created.", (Object)this.decoder.getId());
        this.inputStreamFuture.complete(inputStream);
    }

    @Override
    public void onDataAvailable(int newDataLength) {
        if (newDataLength <= 0) {
            return;
        }
        InputStream inputStream = this.getInputStream();
        LOGGER.trace("SSE Listener ({}): {} bytes available in the stream. Reading...", (Object)this.decoder.getId(), (Object)newDataLength);
        byte[] data = new byte[newDataLength];
        try {
            int actualRead = inputStream.read(data);
            if (actualRead != newDataLength) {
                LOGGER.warn("SSE Listener ({}): Expected to read {} bytes, but actually read {}", new Object[]{this.decoder.getId(), newDataLength, actualRead});
            }
            this.decoder.decode(data, actualRead);
        }
        catch (IOException e) {
            throw new IllegalStateException("SSE Listener (%d): Exception parsing events stream".formatted(this.decoder.getId()), e);
        }
    }

    private InputStream getInputStream() {
        try {
            return this.inputStreamFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("SSE Listener (%d): Interrupted while getting stream".formatted(this.decoder.getId()), e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("SSE Listener (%d): Execution error while getting stream".formatted(this.decoder.getId()), e.getCause());
        }
    }

    @Override
    public void onEndOfStream() {
        LOGGER.trace("SSE Listener ({}): End of the stream. Closing...", (Object)this.decoder.getId());
        this.decoder.close();
    }
}

