/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.xml.parser;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.w3c.dom.Node;

public class XmlApplicationParser {
    private static final String DEFAULT_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/%s";
    static final String CORE_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "core");
    private static final String CORE_PREFIX = "mule";
    private static final String DOMAIN_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "domain");
    private static final String DOMAIN_PREFIX = "domain";
    private static final String EE_DOMAIN_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "ee/domain");
    private static final String EE_DOMAIN_PREFIX = "ee-domain";
    public static final String DECLARED_PREFIX = "DECLARED_PREFIX";
    public static final String XML_NODE = "XML_NODE";
    public static final String LINE_NUMBER = "LINE_NUMBER";
    public static final String CONFIG_FILE_NAME = "CONFIG_FILE_NAME";
    public static final String IS_CDATA = "IS_CDATA";
    private static final String COLON = ":";
    private static final Map<String, String> predefinedNamespace = new HashMap<String, String>();
    private static final String UNDEFINED_NAMESPACE = "undefined";
    private final LazyValue<List<XmlNamespaceInfoProvider>> namespaceInfoProviders;
    private final Cache<String, String> namespaceCache;

    public XmlApplicationParser(List<XmlNamespaceInfoProvider> namespaceInfoProviders) {
        this.namespaceInfoProviders = new LazyValue(Collections.unmodifiableList(new ArrayList<XmlNamespaceInfoProvider>(namespaceInfoProviders)));
        this.namespaceCache = CacheBuilder.newBuilder().build();
    }

    public XmlApplicationParser(Supplier<List<XmlNamespaceInfoProvider>> namespaceInfoProviders) {
        this.namespaceInfoProviders = new LazyValue(namespaceInfoProviders);
        this.namespaceCache = CacheBuilder.newBuilder().build();
    }

    private String loadNamespaceFromProviders(String namespaceUri) {
        if (predefinedNamespace.containsKey(namespaceUri)) {
            return predefinedNamespace.get(namespaceUri);
        }
        for (XmlNamespaceInfoProvider namespaceInfoProvider : (List)this.namespaceInfoProviders.get()) {
            Optional<XmlNamespaceInfo> matchingXmlNamespaceInfo = namespaceInfoProvider.getXmlNamespacesInfo().stream().filter(xmlNamespaceInfo -> namespaceUri.equals(xmlNamespaceInfo.getNamespaceUriPrefix())).findFirst();
            if (!matchingXmlNamespaceInfo.isPresent()) continue;
            return matchingXmlNamespaceInfo.get().getNamespace();
        }
        return UNDEFINED_NAMESPACE;
    }

    public String getNormalizedNamespace(String namespaceUri, String namespacePrefix) {
        try {
            return (String)this.namespaceCache.get((Object)namespaceUri, () -> {
                String namespace = this.loadNamespaceFromProviders(namespaceUri);
                if (namespace == null) {
                    namespace = namespacePrefix;
                }
                return namespace;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public String parseNamespace(Node node) {
        String namespace = CORE_PREFIX;
        if (node.getNodeType() != 4 && (namespace = this.getNormalizedNamespace(node.getNamespaceURI(), node.getPrefix())).equals(UNDEFINED_NAMESPACE)) {
            namespace = node.getPrefix();
        }
        return namespace;
    }

    public String parseNamespaceUri(Node node) {
        String namespace = CORE_NAMESPACE;
        if (node.getNodeType() != 4) {
            namespace = node.getNamespaceURI();
        }
        return namespace;
    }

    public String parseIdentifier(Node node) {
        String identifier = node.getNodeName();
        String[] nameParts = identifier.split(COLON);
        if (nameParts.length > 1) {
            identifier = nameParts[1];
        }
        return identifier;
    }

    public boolean isValidType(Node node) {
        return node.getNodeType() != 3 && node.getNodeType() != 8;
    }

    public static boolean isTextContent(Node node) {
        return node.getNodeType() == 3 || node.getNodeType() == 4;
    }

    static {
        predefinedNamespace.put(CORE_NAMESPACE, CORE_PREFIX);
        predefinedNamespace.put(DOMAIN_NAMESPACE, DOMAIN_PREFIX);
        predefinedNamespace.put(EE_DOMAIN_NAMESPACE, EE_DOMAIN_PREFIX);
    }
}

