/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public final class StringMessageUtils {
    public static final int MAX_ELEMENTS = 50;

    private StringMessageUtils() {
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Map) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            return StringMessageUtils.arrayToString(o, 50);
        }
        if (o instanceof Collection) {
            return StringMessageUtils.collectionToString((Collection)o, 50, false);
        }
        return o.toString();
    }

    public static String arrayToString(Object array, int maxElements) {
        String result;
        Class<?> componentType = array.getClass().getComponentType();
        if (Object.class.isAssignableFrom(componentType)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])((Object[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Boolean.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((boolean[])((boolean[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Byte.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((byte[])((byte[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Character.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((char[])((char[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Short.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((short[])((short[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Integer.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((int[])((int[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Long.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((long[])((long[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Float.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((float[])((float[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Double.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((double[])((double[])array), (int)0, (int)maxElements));
        } else {
            throw new IllegalArgumentException("Unknown array service type: " + componentType.getName());
        }
        if (Array.getLength(array) > maxElements) {
            StringBuilder buf = new StringBuilder(result);
            buf.insert(buf.length() - 1, " [..]");
            result = buf.toString();
        }
        return result;
    }

    private static String collectionToString(Collection c, int maxElements, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        int origNumElements = c.size();
        int numElements = Math.min(origNumElements, maxElements);
        boolean tooManyElements = origNumElements > maxElements;
        StringBuilder buf = new StringBuilder(numElements * 32);
        buf.append('[');
        if (newline) {
            buf.append(System.lineSeparator());
        }
        Iterator items = c.iterator();
        for (int i = 0; i < numElements - 1; ++i) {
            Object item = items.next();
            if (item instanceof Class) {
                buf.append(((Class)item).getName());
            } else {
                buf.append(item);
            }
            if (newline) {
                buf.append(System.lineSeparator());
                continue;
            }
            buf.append(',').append(' ');
        }
        Object lastItem = items.next();
        if (lastItem instanceof Class) {
            buf.append(((Class)lastItem).getName());
        } else {
            buf.append(lastItem);
        }
        if (newline) {
            buf.append(System.lineSeparator());
        }
        if (tooManyElements) {
            buf.append(" [..]");
        }
        buf.append(']');
        return buf.toString();
    }
}

