/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import java.util.Map;
import org.slf4j.MDC;

public class ThreadContext
implements AutoCloseable {
    private final Thread currentThread = Thread.currentThread();
    private final ClassLoader innerClassLoader;
    private final Map<String, String> innerMDC;
    private final ClassLoader outerClassLoader;
    private final Map<String, String> outerMDC;

    public ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
        this.innerClassLoader = classLoader;
        this.innerMDC = mdc;
        this.outerClassLoader = this.currentThread.getContextClassLoader();
        this.outerMDC = MDC.getCopyOfContextMap();
        if (this.innerMDC != null) {
            MDC.setContextMap(this.innerMDC);
        }
        ThreadContext.setContextClassLoader(this.currentThread, this.outerClassLoader, this.innerClassLoader);
    }

    @Override
    public void close() {
        try {
            ThreadContext.setContextClassLoader(this.currentThread, this.innerClassLoader, this.outerClassLoader);
        }
        finally {
            if (this.innerMDC != null) {
                MDC.setContextMap(this.outerMDC);
            }
        }
    }

    public static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader) {
            thread.setContextClassLoader(newClassLoader);
        }
    }
}

