/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;

@NoExtend
public class ApplicationDescriptor
extends DeployableArtifactDescriptor {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "mule-config.xml";
    public static final String REPOSITORY_FOLDER = "repository";
    @Deprecated(since="4.11", forRemoval=true)
    public static final String MULE_APPLICATION_CLASSIFIER = "mule-application";
    @Deprecated(since="4.11", forRemoval=true)
    public static final String MULE_DOMAIN_CLASSIFIER = "mule-domain";
    private String encoding;
    private Map<String, String> appProperties = new HashMap<String, String>();
    private volatile Optional<BundleDescriptor> domainDescriptor;
    private String domainName;

    public ApplicationDescriptor(String name) {
        super(name, Optional.empty());
    }

    public ApplicationDescriptor(String name, Optional<Properties> properties) {
        super(name, properties);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public void setAppProperties(Map<String, String> appProperties) {
        this.appProperties = appProperties;
    }

    public String getDomainName() {
        return this.domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BundleDescriptor> getDomainDescriptor() {
        if (this.domainDescriptor == null) {
            ApplicationDescriptor applicationDescriptor = this;
            synchronized (applicationDescriptor) {
                if (this.domainDescriptor == null) {
                    Optional<BundleDependency> domain = this.getClassLoaderConfiguration().getDependencies().stream().filter(d -> d.getDescriptor().getClassifier().isPresent() && ArtifactType.DOMAIN.getMavenArtifactClassifier().equals(d.getDescriptor().getClassifier().get())).findFirst();
                    this.domainDescriptor = domain.map(BundleDependency::getDescriptor);
                }
            }
        }
        return this.domainDescriptor;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    protected Set<String> getDefaultConfigResources() {
        return Collections.singleton(DEFAULT_CONFIGURATION_RESOURCE);
    }
}

