/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.springframework.beans.factory.FactoryBean;

public class AsyncMessageProcessorsFactoryBean
extends AbstractComponent
implements FactoryBean<Processor>,
MuleContextAware,
NameableObject {
    protected MuleContext muleContext;
    protected List<Processor> messageProcessors;
    protected String name;
    protected Integer maxConcurrency;

    public Class getObjectType() {
        return Processor.class;
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public AsyncDelegateMessageProcessor getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'async' child chain");
        builder.chain(this.messageProcessors);
        AsyncDelegateMessageProcessor delegate = new AsyncDelegateMessageProcessor((MessageProcessorChainBuilder)builder, this.name);
        delegate.setAnnotations(this.getAnnotations());
        if (this.getMaxConcurrency() != null) {
            delegate.setMaxConcurrency(this.getMaxConcurrency());
        }
        return delegate;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }
}

