/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.raml.yagi.framework.nodes.ContextProviderNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNode;

public class NodeUtils {
    private static final int DEFAULT_COLUMN_STEP = 2;

    public static String computeColumnForChild(Node node) {
        return StringUtils.repeat((String)" ", (int)(node.getStartPosition().getColumn() + 2));
    }

    @Nullable
    public static Node getAncestor(Node node, int level) {
        Node parent;
        int i = 1;
        for (parent = node.getParent(); i < level && parent != null; parent = parent.getParent(), ++i) {
        }
        return parent;
    }

    @Nullable
    public static <T extends Node> T getAncestor(Node node, Class<T> ancestorType) {
        Node parent;
        for (parent = node.getParent(); parent != null && !ancestorType.isAssignableFrom(parent.getClass()); parent = parent.getParent()) {
        }
        return (T)((Node)ancestorType.cast(parent));
    }

    @Nullable
    public static <T extends Node> T getSource(Node node, Class<T> ancestorType) {
        Node parent;
        for (parent = node.getSource(); parent != null && !ancestorType.isAssignableFrom(parent.getClass()); parent = parent.getSource()) {
        }
        return (T)((Node)ancestorType.cast(parent));
    }

    public static Node getType(Node node) {
        return node.get("type") != null ? node.get("type") : node.get("schema");
    }

    public static boolean isErrorResult(Node node) {
        return node != null && (node instanceof ErrorNode || node.findDescendantsWith(ErrorNode.class).size() > 0);
    }

    @Nullable
    public static Node searchNodeAt(Node root, int location) {
        if (root.getEndPosition().getIndex() != location || !root.getChildren().isEmpty()) {
            List<Node> children = root.getChildren();
            for (Node child : children) {
                if (child.getEndPosition().getIndex() == location) {
                    if (child.getChildren().isEmpty()) {
                        return child;
                    }
                    return NodeUtils.searchNodeAt(child, location);
                }
                if (child.getEndPosition().getIndex() <= location && !NodeUtils.isLastNode(child)) continue;
                if (child.getChildren().isEmpty()) {
                    return child;
                }
                return NodeUtils.searchNodeAt(child, location);
            }
            return null;
        }
        return root;
    }

    private static boolean isLastNode(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        List<Node> children = parent.getChildren();
        Node lastChild = children.get(children.size() - 1);
        return node.equals(lastChild);
    }

    public static boolean isNull(Node node) {
        return node == null || node instanceof NullNode;
    }

    public static Node getRootSource(Node child) {
        Node result;
        for (result = child; result != null && result.getSource() != null; result = result.getSource()) {
        }
        return result;
    }

    @Nullable
    public static Node traverseToRoot(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getParent() == null) {
            return node;
        }
        return NodeUtils.traverseToRoot(node.getParent());
    }

    @Nonnull
    public static Node getContextNode(Node node) {
        if (node.getParent() == null) {
            return node;
        }
        if (node instanceof ContextProviderNode) {
            return ((ContextProviderNode)((Object)node)).getContextNode();
        }
        return NodeUtils.getContextNode(node.getParent());
    }
}

